/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.credentialsbinding.impl;

import com.cloudbees.plugins.credentials.CredentialsProvider;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.FilePath;
import hudson.model.Item;
import hudson.util.FormValidation;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import jenkins.model.Jenkins;
import org.apache.commons.io.IOUtils;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.credentialsbinding.BindingDescriptor;
import org.jenkinsci.plugins.credentialsbinding.impl.AbstractOnDiskBinding;
import org.jenkinsci.plugins.credentialsbinding.impl.Messages;
import org.jenkinsci.plugins.plaincredentials.FileCredentials;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

public class ZipFileBinding
extends AbstractOnDiskBinding<FileCredentials> {
    @DataBoundConstructor
    public ZipFileBinding(String variable, String credentialsId) {
        super(variable, credentialsId);
    }

    @Override
    protected Class<FileCredentials> type() {
        return FileCredentials.class;
    }

    @Override
    protected final FilePath write(FileCredentials credentials, FilePath dir) throws IOException, InterruptedException {
        FilePath secret = dir.child(credentials.getFileName());
        secret.unzipFrom(credentials.getContent());
        secret.chmod(448);
        return secret;
    }

    @Symbol(value={"zip"})
    @Extension
    public static class DescriptorImpl
    extends BindingDescriptor<FileCredentials> {
        @Override
        protected Class<FileCredentials> type() {
            return FileCredentials.class;
        }

        @NonNull
        public String getDisplayName() {
            return Messages.ZipFileBinding_secret_zip_file();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public FormValidation doCheckCredentialsId(StaplerRequest req, @AncestorInPath Item owner, @QueryParameter String value) {
            if (!req.getMethod().equals("POST")) {
                return FormValidation.ok();
            }
            if (owner == null ? !Jenkins.get().hasPermission(Jenkins.ADMINISTER) : !owner.hasPermission(Item.EXTENDED_READ) && !owner.hasPermission(CredentialsProvider.USE_ITEM)) {
                return FormValidation.ok();
            }
            for (FileCredentials c : CredentialsProvider.lookupCredentials(FileCredentials.class, (Item)owner, null, Collections.emptyList())) {
                if (!c.getId().equals(value)) continue;
                InputStream is = null;
                try {
                    is = c.getContent();
                    byte[] data = new byte[4];
                    if (is.read(data) == 4 && data[0] == 80 && data[1] == 75 && data[2] == 3 && data[3] == 4) {
                        FormValidation formValidation = FormValidation.ok();
                        return formValidation;
                    }
                    FormValidation formValidation = FormValidation.error((String)Messages.ZipFileBinding_NotZipFile());
                    return formValidation;
                }
                catch (IOException x) {
                    FormValidation formValidation = FormValidation.warning((String)Messages.ZipFileBinding_CouldNotVerifyFileFormat());
                    return formValidation;
                }
                finally {
                    if (is != null) {
                        IOUtils.closeQuietly((InputStream)is);
                    }
                }
            }
            return FormValidation.error((String)Messages.ZipFileBinding_NoSuchCredentials());
        }
    }
}

