/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.crap4j.model;

import com.schneide.crap4j.reader.model.IOverallStatistics;
import hudson.plugins.crap4j.calculation.CrapDataComparer;
import hudson.plugins.crap4j.display.ICrapComparison;
import hudson.plugins.crap4j.model.IMethodCrap;
import java.io.Serializable;
import java.lang.ref.WeakReference;

public class ProjectCrapBean
implements Serializable {
    private static final long serialVersionUID = -5174742165631443987L;
    private final IMethodCrap[] crapMethods;
    private final String name;
    private final double totalCrap;
    private final int methodCount;
    private final int crapMethodCount;
    private final double crapMethodPercent;
    private final int crapLoad;
    private final int newCrapMethodsCount;
    private final int fixedCrapMethodsCount;
    private transient WeakReference<IMethodCrap[]> newCrapMethods;
    private transient WeakReference<IMethodCrap[]> fixedCrapMethods;

    public ProjectCrapBean(ProjectCrapBean previousCrap, IOverallStatistics statistics, IMethodCrap ... crapMethodData) {
        this.crapMethods = crapMethodData;
        this.name = statistics.getName();
        this.totalCrap = statistics.getTotalCrap();
        this.methodCount = statistics.getMethodCount();
        this.crapMethodCount = statistics.getCrapMethodCount();
        this.crapMethodPercent = statistics.getCrapMethodPercent();
        this.crapLoad = statistics.getCrapLoad();
        ICrapComparison comparison = this.compareWithPreviousCrap(previousCrap);
        this.newCrapMethodsCount = comparison.getNewCrapMethods().length;
        this.fixedCrapMethodsCount = comparison.getFixedCrapMethods().length;
        this.loadCrapMethodComparison(comparison);
    }

    private ICrapComparison compareWithPreviousCrap(ProjectCrapBean previousCrap) {
        IMethodCrap[] previousCrapMethods = new IMethodCrap[]{};
        if (null != previousCrap) {
            previousCrapMethods = previousCrap.getCrapMethods();
        }
        CrapDataComparer comparison = new CrapDataComparer(previousCrapMethods, this.crapMethods);
        return comparison;
    }

    private void loadCrapMethodComparison(ProjectCrapBean previousCrap) {
        this.loadCrapMethodComparison(this.compareWithPreviousCrap(previousCrap));
    }

    public IMethodCrap[] getFixedMethods(ProjectCrapBean previousCrap) {
        if (null == this.fixedCrapMethods) {
            this.loadCrapMethodComparison(previousCrap);
        }
        if (null == this.fixedCrapMethods.get()) {
            this.loadCrapMethodComparison(previousCrap);
        }
        return (IMethodCrap[])this.fixedCrapMethods.get();
    }

    public IMethodCrap[] getNewMethods(ProjectCrapBean previousCrap) {
        if (null == this.newCrapMethods) {
            this.loadCrapMethodComparison(previousCrap);
        }
        if (null == this.newCrapMethods.get()) {
            this.loadCrapMethodComparison(previousCrap);
        }
        return (IMethodCrap[])this.newCrapMethods.get();
    }

    private void loadCrapMethodComparison(ICrapComparison comparison) {
        this.newCrapMethods = new WeakReference<IMethodCrap[]>(comparison.getNewCrapMethods());
        this.fixedCrapMethods = new WeakReference<IMethodCrap[]>(comparison.getFixedCrapMethods());
    }

    public IMethodCrap[] getCrapMethods() {
        return this.crapMethods;
    }

    public String getName() {
        return this.name;
    }

    public double getTotalCrap() {
        return this.totalCrap;
    }

    public int getMethodCount() {
        return this.methodCount;
    }

    public int getCrapMethodCount() {
        return this.crapMethodCount;
    }

    public double getCrapMethodPercent() {
        return this.crapMethodPercent;
    }

    public int getCrapLoad() {
        return this.crapLoad;
    }

    public int getNewCrapMethodsCount() {
        return this.newCrapMethodsCount;
    }

    public int getFixedCrapMethodsCount() {
        return this.fixedCrapMethodsCount;
    }
}

