/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.covcomplplot.analyzer;

import hudson.Functions;
import hudson.model.AbstractBuild;
import hudson.plugins.covcomplplot.analyzer.AbstractMethodInfoHandler;
import hudson.plugins.covcomplplot.analyzer.Analyzer;
import hudson.plugins.covcomplplot.model.MethodInfo;
import hudson.plugins.covcomplplot.stub.InvalidHudsonProjectException;
import hudson.plugins.covcomplplot.stub.InvalidHudsonProjectType;
import hudson.plugins.covcomplplot.stub.LoggerWrapper;
import hudson.plugins.covcomplplot.util.CovComplPlotUtil;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Document;
import org.dom4j.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CloverBranchCoverageMethodHandler
extends AbstractMethodInfoHandler {
    @Override
    public List<MethodInfo> process(AbstractBuild<?, ?> build, boolean excludeGetterSetter, String remoteDir, LoggerWrapper logger, Analyzer analyzer) throws InvalidHudsonProjectException {
        Document clover = super.getBuildArtifact(build, "clover.xml", Analyzer.Clover);
        List elementList = null;
        Element eachElement = clover.getRootElement();
        try {
            if (CovComplPlotUtil.compareVersion(eachElement.attributeValue("clover"), "3.0.0") < 0) {
                throw new InvalidHudsonProjectException(InvalidHudsonProjectType.INTERNAL, "Clover version should be over 3.0.0.");
            }
            eachElement = eachElement.element("project");
            elementList = eachElement.elements("package");
        }
        catch (Exception e) {
            throw new InvalidHudsonProjectException(InvalidHudsonProjectType.INTERNAL, "clover.xml doesn't contain valid result.");
        }
        ArrayList<MethodInfo> methods = new ArrayList<MethodInfo>();
        for (Element eachPackage : elementList) {
            String dirPath = eachPackage.attributeValue("name");
            for (Object eachFileObject : eachPackage.elements("file")) {
                Element eachFileElement = (Element)eachFileObject;
                String path = dirPath.replace(".", "/") + "/" + eachFileElement.attributeValue("name");
                MethodInfo cloverMethod = null;
                for (Object each : eachFileElement.elements("line")) {
                    Element eachLine = (Element)each;
                    String eachType = eachLine.attributeValue("type");
                    if ("method".equals(eachType)) {
                        String signature = eachLine.attributeValue("signature");
                        int complexity = Integer.parseInt(eachLine.attributeValue("complexity"));
                        int lineno = Integer.parseInt(eachLine.attributeValue("num"));
                        cloverMethod = new MethodInfo(path, signature, complexity, lineno);
                        boolean bl = cloverMethod.covered = !"0".equals(eachLine.attributeValue("count"));
                        if (!this.isMethodValid(cloverMethod, excludeGetterSetter)) {
                            cloverMethod = null;
                            continue;
                        }
                        methods.add(cloverMethod);
                        continue;
                    }
                    if (!"cond".equals(eachType) || cloverMethod == null) continue;
                    int count = "0".equals(eachLine.attributeValue("truecount")) ? 0 : 1;
                    cloverMethod.increaseSizeAndCovered(2, count += "0".equals(eachLine.attributeValue("falsecount")) ? 0 : 1);
                }
            }
        }
        return methods;
    }

    @Override
    protected boolean isMethodValid(MethodInfo method, boolean excludeGetterSetter) {
        if (method == null) {
            return true;
        }
        if (excludeGetterSetter) {
            return !this.isGetterSetter(method);
        }
        return true;
    }

    @Override
    protected boolean isGetterSetter(MethodInfo method) {
        if (method.getCompl() == 1) {
            return StringUtils.startsWithIgnoreCase((String)method.getSig(), (String)"get") || StringUtils.startsWithIgnoreCase((String)method.getSig(), (String)"set");
        }
        return false;
    }

    @Override
    public String getCustomJavaScript() {
        return CovComplPlotUtil.getFileAsString(CovComplPlotUtil.getClassResourcePath(this.getClass(), "js"));
    }

    @Override
    public String getMethodUrlLocation(AbstractBuild<?, ?> owner, MethodInfo methodInfo) {
        String cloverPath = methodInfo.getPath();
        if (cloverPath.endsWith(".java")) {
            cloverPath = cloverPath.replaceAll("\\.java$", "");
        }
        return String.format("%s/clover-report/%s.html#%d", owner.getUrl(), Functions.encode((String)cloverPath), methodInfo.line);
    }

    @Override
    public void checkBuild(AbstractBuild<?, ?> build) throws InvalidHudsonProjectException {
        this.checkBuildContainningBuildAction(build, "clover");
    }

    @Override
    public String getDescription() {
        return "Clover plugin result is used for generating this plot.<br/> In this case, the coverage means branch coverage.";
    }
}

