/*
 * Decompiled with CFR 0.152.
 */
package com.infostretch.labs.utils;

import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import com.google.common.base.Strings;
import com.infostretch.labs.plugins.Plugins;
import hudson.model.Item;
import hudson.security.ACL;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.Collections;
import java.util.List;
import jenkins.model.Jenkins;
import org.acegisecurity.Authentication;
import org.apache.commons.io.FileUtils;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.UsernamePasswordCredentialsProvider;

public class SCMUtil {
    public void pushJenkinsfile(String script, String url, String branchName, String credentialsId, String commitMessage, String scmType) {
        StandardUsernamePasswordCredentials credentials = this.getCredentials(credentialsId);
        UsernamePasswordCredentialsProvider credentialsProvider = new UsernamePasswordCredentialsProvider(credentials.getUsername(), credentials.getPassword().getPlainText());
        File workSpace = new File(Jenkins.getInstance().getRootDir(), "plugins/convert-to-pipeline/ws");
        this.cleanWorkSpace(workSpace);
        try {
            Class pluginClass = Plugins.getPluginClass(scmType);
            if (pluginClass != null) {
                Constructor pluginConstructor = pluginClass.getConstructor(new Class[0]);
                Plugins plugin = (Plugins)pluginConstructor.newInstance(new Object[0]);
                plugin.pushJenkinsfile(workSpace, script, url, branchName, commitMessage, (CredentialsProvider)credentialsProvider);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.cleanWorkSpace(workSpace);
    }

    public static void writeJenkinsfile(File workSpace, String script) {
        try {
            File jenkinsFile = new File(workSpace.getAbsolutePath() + "/Jenkinsfile");
            FileUtils.writeStringToFile((File)jenkinsFile, (String)script);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void cleanWorkSpace(File workSpace) {
        if (workSpace.exists()) {
            try {
                FileUtils.deleteDirectory((File)workSpace);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private StandardUsernamePasswordCredentials getCredentials(String credentialId) {
        StandardUsernamePasswordCredentials cred;
        if (!Strings.isNullOrEmpty((String)credentialId) && (cred = (StandardUsernamePasswordCredentials)CredentialsMatchers.firstOrNull(this.fetchAllCredentials(), (CredentialsMatcher)CredentialsMatchers.withId((String)credentialId))) != null) {
            return cred;
        }
        return null;
    }

    private List<StandardUsernamePasswordCredentials> fetchAllCredentials() {
        return com.cloudbees.plugins.credentials.CredentialsProvider.lookupCredentials(StandardUsernamePasswordCredentials.class, (Item)null, (Authentication)ACL.SYSTEM, Collections.emptyList());
    }
}

