/*
 * Decompiled with CFR 0.152.
 */
package com.infostretch.labs.utils;

import com.cloudbees.hudson.plugins.folder.Folder;
import com.infostretch.labs.transformers.Transformer;
import hudson.model.FreeStyleProject;
import hudson.model.TopLevelItem;
import java.io.IOException;
import java.util.HashMap;
import javax.servlet.ServletException;
import jenkins.model.Jenkins;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public class ActionUtil {
    private FreeStyleProject job;

    public ActionUtil(FreeStyleProject job) {
        this.job = job;
    }

    public static boolean validateForm(String newName, String originalJob) {
        TopLevelItem item = null;
        try {
            FreeStyleProject orgJob = (FreeStyleProject)Jenkins.getInstance().getItemByFullName(originalJob);
            if (orgJob != null) {
                newName = ActionUtil.defineName(newName, orgJob.getName());
                item = orgJob.getParent().getClass().equals(Folder.class) ? ((Folder)orgJob.getParent()).getItem(newName) : Jenkins.getInstance().getItem(newName);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return item == null;
        }
        return item == null;
    }

    public void doConvert(StaplerRequest request, StaplerResponse response) throws ServletException, IOException {
        try {
            TopLevelItem newJob;
            String newName = request.getParameter("newName");
            boolean convertDownStream = false;
            boolean commitJenkinsfile = false;
            String commitMessage = request.getParameter("commitMessage");
            if (request.getParameter("downStream") != null && request.getParameter("downStream").equalsIgnoreCase("on")) {
                convertDownStream = true;
            }
            if (request.getParameter("commitJFile") != null && request.getParameter("commitJFile").equalsIgnoreCase("on")) {
                commitJenkinsfile = true;
            }
            if (commitJenkinsfile && commitMessage.isEmpty()) {
                commitMessage = "";
            }
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("initialProject", this.job);
            params.put("downStream", convertDownStream);
            params.put("commitJenkinsfile", commitJenkinsfile);
            params.put("commitMessage", commitMessage);
            newName = ActionUtil.defineName(newName, this.job.getName());
            if (this.job.getParent().getClass().equals(Folder.class)) {
                Folder folder = (Folder)this.job.getParent();
                Transformer transformer = new Transformer(params);
                transformer.performFreeStyleTransformation();
                newJob = folder.createProjectFromXML(newName, transformer.getStream());
            } else {
                Transformer transformer = new Transformer(params);
                transformer.performFreeStyleTransformation();
                newJob = Jenkins.getInstance().createProjectFromXML(newName, transformer.getStream());
            }
            Jenkins.getInstance().reload();
            response.sendRedirect2(newJob.getAbsoluteUrl());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String defineName(String name, String jobName) {
        if (name.isEmpty()) {
            name = jobName + "-pipeline";
        }
        return name;
    }
}

