/*
 * Decompiled with CFR 0.152.
 */
package com.infostretch.labs.transformers;

import com.infostretch.labs.plugins.Plugins;
import com.infostretch.labs.transformers.BuilderTransformer;
import com.infostretch.labs.transformers.PublisherTransformer;
import com.infostretch.labs.transformers.SCMTransformer;
import com.infostretch.labs.utils.SCMUtil;
import hudson.model.FreeStyleProject;
import hudson.model.Item;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Transformer {
    private static final Logger logger = Logger.getLogger(Transformer.class.getName());
    private InputStream is;
    private Element flowDefinition;
    private String scmURL = "";
    private String scmCredentialsId = "";
    private String scmType = "";
    private String scmBranch = "";
    protected Document doc;
    protected Document dest;
    public Element jdk;
    protected NodeList buildersList;
    public boolean firstJob = true;
    public StringBuffer script;
    public StringBuffer buildSteps;
    public StringBuffer publishSteps;
    public String currentJobName = "";
    public String previousUrl = "";
    public String previousLabel = "";
    private Map<String, Object> requestParams;
    private List<String> copyConfigs = new ArrayList<String>(Arrays.asList("description", "properties", "triggers"));
    private List<String> transformConfigs = new ArrayList<String>(Arrays.asList("label", "scm", "builders", "publishers"));
    private boolean onlyBuildTrigger = true;

    public Transformer(Map requestParams) {
        this.script = new StringBuffer();
        this.requestParams = requestParams;
    }

    public void performFreeStyleTransformation() {
        this.appendToScript("// Powered by Infostretch \n\n");
        this.appendToScript("timestamps {\n");
        this.transformJob((FreeStyleProject)this.requestParams.get("initialProject"), (Boolean)this.requestParams.get("downStream"));
        this.appendToScript("\n}\n}");
        this.appendScriptToXML((Boolean)this.requestParams.get("commitJenkinsfile"), this.requestParams.get("commitMessage").toString());
        this.writeConfiguration();
        logger.info("Completed conversion of all jobs");
    }

    private void transformJob(FreeStyleProject item, boolean downStream) {
        try {
            this.currentJobName = item.getFullName();
            this.doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(item.getConfigFile().getFile());
            this.dest = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            this.flowDefinition = this.dest.createElement("flow-definition");
            this.dest.appendChild(this.flowDefinition);
            this.doc.getDocumentElement().normalize();
            this.transformFile();
            if (downStream) {
                for (Item job : item.getDownstreamProjects()) {
                    if (!(job instanceof FreeStyleProject)) continue;
                    this.firstJob = false;
                    this.transformJob((FreeStyleProject)job, true);
                }
            }
        }
        catch (Exception e) {
            logger.severe("Exception occurred in Transformer constructor: " + e.getMessage());
        }
    }

    public InputStream getStream() {
        return this.is;
    }

    private void transformFile() {
        this.copyConfigurations(this.copyConfigs);
        this.transformConfigurations(this.transformConfigs);
    }

    private void transformConfigurations(List<String> configurations) {
        for (String config : configurations) {
            logger.info("Transforming configuration: " + config.toUpperCase());
            switch (config) {
                case "label": {
                    this.transformLabel();
                    break;
                }
                case "scm": {
                    SCMTransformer scmTransformer = new SCMTransformer(this);
                    scmTransformer.convertSCM();
                    break;
                }
                case "builders": {
                    BuilderTransformer builderTransformer = new BuilderTransformer(this);
                    builderTransformer.convertBuilders();
                    break;
                }
                case "publishers": {
                    PublisherTransformer publisherTransformer = new PublisherTransformer(this);
                    publisherTransformer.convertPublishers();
                    break;
                }
            }
        }
    }

    private void copyConfigurations(List<String> configurations) {
        for (String configuration : configurations) {
            logger.info("Transforming configuration: " + configuration.toUpperCase());
            if (this.doc.getElementsByTagName(configuration).getLength() <= 0) continue;
            Node destConfigNode = this.dest.importNode(this.doc.getElementsByTagName(configuration).item(0), true);
            if (configuration.equalsIgnoreCase("properties")) {
                NodeList propertyChildren = destConfigNode.getChildNodes();
                for (int i = 1; i < propertyChildren.getLength(); i += 2) {
                    Node property = propertyChildren.item(i);
                    if (!property.getNodeName().contains("DiskUsageProperty")) continue;
                    logger.info("Disk usage property found and discarded");
                    property.getParentNode().removeChild(property);
                    break;
                }
            }
            this.flowDefinition.appendChild(destConfigNode);
        }
    }

    private void transformLabel() {
        String label = "";
        if (this.doc.getElementsByTagName("assignedNode").getLength() > 0) {
            label = this.doc.getElementsByTagName("assignedNode").item(0).getTextContent();
            if (this.firstJob) {
                this.appendToScript("\nnode ('" + label + "') { \n");
            } else if (!label.equalsIgnoreCase(this.previousLabel)) {
                this.appendToScript("\n}\nnode ('" + label + "') { \n");
            }
        } else if (this.firstJob) {
            this.appendToScript("\nnode () {\n");
        } else if (!label.equalsIgnoreCase(this.previousLabel)) {
            this.appendToScript("\n}\nnode () { \n");
        }
        this.previousLabel = label;
    }

    public void appendToScript(String stage, String block) {
        this.script.append("\n\tstage ('" + stage + "') {\n \t " + block + " \n\t}");
    }

    public void appendToScript(String block) {
        this.script.append(block);
    }

    private void appendScriptToXML(boolean commitJenkinsfile, String commitMessage) {
        if (commitJenkinsfile) {
            new SCMUtil().pushJenkinsfile(this.script.toString(), this.scmURL, this.scmBranch, this.scmCredentialsId, commitMessage, this.scmType);
            this.flowDefinition.appendChild(this.writeCPSFlow());
        } else {
            Element definition = this.dest.createElement("definition");
            definition.setAttribute("class", "org.jenkinsci.plugins.workflow.cps.CpsFlowDefinition");
            Element scriptDefinition = this.dest.createElement("script");
            scriptDefinition.setTextContent(this.script.toString());
            definition.appendChild(scriptDefinition);
            this.flowDefinition.appendChild(definition);
        }
    }

    public Element getElementByTag(Node node, String tag) {
        return (Element)((Element)node).getElementsByTagName(tag).item(0);
    }

    private void writeConfiguration() {
        try {
            javax.xml.transform.Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            transformer.transform(new DOMSource(this.dest), new StreamResult(outputStream));
            this.is = new ByteArrayInputStream(outputStream.toByteArray());
            logger.info("Transformation for job " + this.currentJobName + " completed successfully");
        }
        catch (Exception e) {
            logger.severe("Exception occurred: " + e.getMessage());
        }
    }

    public void setScmBranch(String scmBranch) {
        this.scmBranch = scmBranch;
    }

    public void setScmURL(String scmURL) {
        this.scmURL = scmURL;
    }

    public void setScmType(String scmType) {
        this.scmType = scmType;
    }

    public void setScmCredentialsId(String scmCredentialsId) {
        this.scmCredentialsId = scmCredentialsId;
    }

    private Element writeCPSFlow() {
        try {
            Class pluginClass = Plugins.getPluginClass(this.scmType);
            if (pluginClass != null) {
                Constructor pluginConstructor = pluginClass.getConstructor(new Class[0]);
                Plugins plugin = (Plugins)pluginConstructor.newInstance(new Object[0]);
                return plugin.writeCPSFlow(this.dest, this.scmURL, this.scmBranch, this.scmCredentialsId);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public void setOnlyBuildTrigger(boolean value) {
        this.onlyBuildTrigger = value;
    }

    public boolean getOnlyBuildTrigger() {
        return this.onlyBuildTrigger;
    }
}

