/*
 * Decompiled with CFR 0.152.
 */
package com.infostretch.labs.transformers;

import com.infostretch.labs.plugins.Plugins;
import com.infostretch.labs.transformers.Transformer;
import com.infostretch.labs.utils.PluginIgnoredClass;
import java.lang.reflect.Constructor;
import org.w3c.dom.Node;

public class SCMTransformer {
    private Transformer transformer;
    private Node scm;

    protected SCMTransformer(Transformer transformer) {
        this.transformer = transformer;
    }

    protected void convertSCM() {
        if (this.transformer.doc.getElementsByTagName("scm").getLength() > 0) {
            this.scm = this.transformer.doc.getElementsByTagName("scm").item(0);
            String scmType = this.scm.getAttributes().getNamedItem("class").getTextContent();
            try {
                Class pluginClass = Plugins.getPluginClass(scmType);
                if (pluginClass != null) {
                    Constructor pluginConstructor = pluginClass.getConstructor(Transformer.class, Node.class);
                    Plugins plugin = (Plugins)pluginConstructor.newInstance(this.transformer, this.scm);
                    plugin.transformSCM();
                } else {
                    PluginIgnoredClass ignoredPlugin = PluginIgnoredClass.searchByValue(scmType);
                    if (ignoredPlugin == null) {
                        this.transformer.appendToScript(this.transformer.currentJobName + " - Checkout", "\n// Unable to convert SCM referring to \"" + scmType + "\". Please verify and convert manually if required.");
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (this.transformer.firstJob) {
                this.transformer.setScmType(scmType);
            }
        }
    }
}

