/*
 * Decompiled with CFR 0.152.
 */
package com.infostretch.labs.transformers;

import com.infostretch.labs.plugins.Plugins;
import com.infostretch.labs.transformers.Transformer;
import java.lang.reflect.Constructor;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PublisherTransformer {
    private Transformer transformer;

    protected PublisherTransformer(Transformer transformer) {
        this.transformer = transformer;
    }

    protected void convertPublishers() {
        if (this.transformer.doc.getElementsByTagName("publishers").getLength() > 0) {
            Element publishers = (Element)this.transformer.doc.getElementsByTagName("publishers").item(0);
            NodeList publishersList = publishers.getChildNodes();
            this.transformer.publishSteps = new StringBuffer();
            this.transformer.setOnlyBuildTrigger(true);
            if (publishersList.getLength() > 0) {
                this.transformer.publishSteps.append("\n\tstage ('" + this.transformer.currentJobName + " - Post build actions') {");
                this.transformer.publishSteps.append("\n/*\nPlease note this is a direct conversion of post-build actions. \nIt may not necessarily work/behave in the same way as post-build actions work.\nA logic review is suggested.\n*/");
            }
            for (int i = 1; i < publishersList.getLength(); i += 2) {
                Node publisher = publishersList.item(i);
                try {
                    Class pluginClass = Plugins.getPluginClass(publisher.getNodeName());
                    if (pluginClass != null) {
                        Constructor pluginConstructor = pluginClass.getConstructor(Transformer.class, Node.class);
                        Plugins plugin = (Plugins)pluginConstructor.newInstance(this.transformer, publisher);
                        plugin.transformPublisher();
                        continue;
                    }
                    this.transformer.publishSteps.append("\n// Unable to convert a post-build action referring to \"" + publisher.getNodeName() + "\". Please verify and convert manually if required.");
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (this.transformer.buildersList.getLength() > 0) {
                if (this.transformer.jdk != null && !this.transformer.jdk.getTextContent().equals("(System)")) {
                    this.transformer.buildSteps.append(" \n\t}\n}");
                } else {
                    this.transformer.buildSteps.append(" \n\t}");
                }
            }
            this.transformer.appendToScript(this.transformer.buildSteps.toString());
            if (publishersList.getLength() > 0) {
                this.transformer.publishSteps.append(" \n\t}");
            }
            if (!this.transformer.getOnlyBuildTrigger()) {
                this.transformer.appendToScript(this.transformer.publishSteps.toString());
            }
        }
    }
}

