/*
 * Decompiled with CFR 0.152.
 */
package com.infostretch.labs.transformers;

import com.infostretch.labs.plugins.Plugins;
import com.infostretch.labs.transformers.Transformer;
import com.infostretch.labs.utils.PluginIgnoredClass;
import java.lang.reflect.Constructor;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class BuilderTransformer {
    private Transformer transformer;

    protected BuilderTransformer(Transformer transformer) {
        this.transformer = transformer;
    }

    public void convertBuilders() {
        if (this.transformer.doc.getElementsByTagName("builders").getLength() > 0) {
            Element buildWrappers;
            Element builders = (Element)this.transformer.doc.getElementsByTagName("builders").item(0);
            this.transformer.buildersList = builders.getChildNodes();
            this.transformer.buildSteps = new StringBuffer();
            if (this.transformer.buildersList.getLength() > 0) {
                this.transformer.buildSteps.append("\n\tstage ('" + this.transformer.currentJobName + " - Build') {\n \t");
            }
            this.transformer.jdk = (Element)this.transformer.doc.getElementsByTagName("jdk").item(0);
            if (this.transformer.jdk != null && !this.transformer.jdk.getTextContent().equals("(System)")) {
                this.transformer.buildSteps.append("\nwithEnv([\"JAVA_HOME=${ tool '\"+JDK+\"' }\", \"PATH=${env.JAVA_HOME}/bin\"]) { \n");
            }
            if ((buildWrappers = (Element)this.transformer.doc.getElementsByTagName("buildWrappers").item(0)) != null) {
                NodeList buildWrappersList = buildWrappers.getChildNodes();
                for (int i = 1; i < buildWrappersList.getLength(); i += 2) {
                    Node buildWrapper = buildWrappersList.item(i);
                    try {
                        Class pluginClass = Plugins.getPluginClass(buildWrapper.getNodeName());
                        if (pluginClass != null) {
                            Constructor pluginConstructor = pluginClass.getConstructor(Transformer.class, Node.class);
                            Plugins plugin = (Plugins)pluginConstructor.newInstance(this.transformer, buildWrapper);
                            plugin.transformBuildWrapper();
                            continue;
                        }
                        PluginIgnoredClass ignoredPlugin = PluginIgnoredClass.searchByValue(buildWrapper.getNodeName());
                        if (ignoredPlugin != null) continue;
                        this.transformer.buildSteps.append("\n// Unable to convert a build step referring to \"" + buildWrapper.getNodeName() + "\". Please verify and convert manually if required.");
                        continue;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            for (int i = 1; i < this.transformer.buildersList.getLength(); i += 2) {
                Node builder = this.transformer.buildersList.item(i);
                try {
                    Class pluginClass = Plugins.getPluginClass(builder.getNodeName());
                    if (pluginClass != null) {
                        Constructor pluginConstructor = pluginClass.getConstructor(Transformer.class, Node.class);
                        Plugins plugin = (Plugins)pluginConstructor.newInstance(this.transformer, builder);
                        plugin.transformBuild();
                        continue;
                    }
                    PluginIgnoredClass ignoredPlugin = PluginIgnoredClass.searchByValue(builder.getNodeName());
                    if (ignoredPlugin != null) continue;
                    this.transformer.buildSteps.append("\n// Unable to convert a build step referring to \"" + builder.getNodeName() + "\". Please verify and convert manually if required.");
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

