/*
 * Decompiled with CFR 0.152.
 */
package com.infostretch.labs.plugins;

import com.infostretch.labs.plugins.Plugins;
import com.infostretch.labs.transformers.Transformer;
import java.util.regex.Pattern;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Maven
extends Plugins {
    public Maven(Transformer transformer, Node node) {
        super(transformer, node);
    }

    @Override
    public void transformBuild() {
        this.appendBuildSteps("\t\t// Maven build step");
        Element settingsPath = null;
        Element globalSettingsPath = null;
        StringBuffer mvnParams = new StringBuffer();
        StringBuffer mvnTargets = new StringBuffer();
        String mavenParams = "";
        Element targets = this.getElementByTag("targets");
        Element mavenName = this.getElementByTag("mavenName");
        Element jvmOptions = this.getElementByTag("jvmOptions");
        Element pom = this.getElementByTag("pom");
        Element properties = this.getElementByTag("properties");
        Element usePrivateRepository = this.getElementByTag("usePrivateRepository");
        Element injectBuildVariables = this.getElementByTag("injectBuildVariables");
        Element settings = this.getElementByTag("settings");
        Element globalSettings = this.getElementByTag("globalSettings");
        if (settings != null) {
            settingsPath = this.getElementByTag(settings, "path");
        }
        if (globalSettings != null) {
            globalSettingsPath = this.getElementByTag(globalSettings, "path");
        }
        if (this.transformer.jdk != null && !this.transformer.jdk.getTextContent().equals("(System)")) {
            mvnParams.append(" jdk: '" + this.transformer.jdk.getTextContent() + "',");
        }
        if (mavenName != null) {
            mvnParams.append(" maven: '" + mavenName.getTextContent() + "',");
        }
        if (jvmOptions != null) {
            mvnParams.append(" mavenOpts: '" + jvmOptions.getTextContent() + "',");
        }
        if (usePrivateRepository != null && usePrivateRepository.getTextContent().equals("true")) {
            mvnParams.append(" mavenLocalRepo: \"$WORKSPACE/.repository\",");
        }
        if (settingsPath != null) {
            mvnParams.append(" mavenSettingsFilePath: '" + settingsPath.getTextContent() + "',");
        }
        if (globalSettingsPath != null) {
            mvnParams.append(" globalMavenSettingsFilePath: '" + globalSettingsPath.getTextContent() + "',");
        }
        if (injectBuildVariables != null) {
            // empty if block
        }
        if (pom != null) {
            mvnTargets.append("-f " + pom.getTextContent() + " ");
        }
        if (properties != null) {
            mvnTargets.append(Pattern.compile("\n", 8).matcher(Pattern.compile("^", 8).matcher(Pattern.compile("^#.*", 8).matcher(properties.getTextContent()).replaceAll("").trim()).replaceAll("-D").trim()).replaceAll(" ").trim() + " ");
        }
        if (targets != null) {
            mvnTargets.append(targets.getTextContent() + " ");
        }
        if ((mavenParams = mvnParams.length() > 0 && String.valueOf(mvnParams.charAt(mvnParams.length() - 1)).equals(",") ? mvnParams.substring(0, mvnParams.length() - 1).trim() : mvnParams.toString().trim()).length() > 0) {
            this.appendBuildSteps("\n\twithMaven(" + mavenParams + ") { \n \t\t\tif(isUnix()) {\n \t\t\t\tsh \"mvn " + mvnTargets + "\" \n\t\t\t} else { \n \t\t\t\tbat \"mvn " + mvnTargets + "\" \n\t\t\t} \n \t\t}");
        } else {
            this.appendBuildSteps("\n\twithMaven { \n \t\t\tif(isUnix()) {\n \t\t\t\tsh \"mvn " + mvnTargets + "\" \n\t\t\t} else { \n \t\t\t\tbat \"mvn " + mvnTargets + "\" \n\t\t\t} \n \t\t}");
        }
    }
}

