/*
 * Decompiled with CFR 0.152.
 */
package com.infostretch.labs.plugins;

import com.infostretch.labs.plugins.Plugins;
import com.infostretch.labs.transformers.Transformer;
import com.infostretch.labs.utils.SCMUtil;
import java.io.File;
import java.util.Iterator;
import java.util.logging.Logger;
import org.eclipse.jgit.api.AddCommand;
import org.eclipse.jgit.api.CloneCommand;
import org.eclipse.jgit.api.CommitCommand;
import org.eclipse.jgit.api.PushCommand;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.PushResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Git
extends Plugins {
    private static final Logger logger = Logger.getLogger(Git.class.getName());

    public Git(Transformer transformer, Node node) {
        super(transformer, node);
    }

    public Git() {
    }

    @Override
    public void transformSCM() {
        String repoURL = "";
        String branch = "";
        String repoCredentials = "";
        NodeList scmProps = this.node.getChildNodes();
        for (int i = 1; i < scmProps.getLength(); i += 2) {
            Node scmProp = scmProps.item(i);
            Element url = this.transformer.getElementByTag(scmProp, "url");
            Element credentialsId = this.transformer.getElementByTag(scmProp, "credentialsId");
            Element branchName = this.transformer.getElementByTag(scmProp, "name");
            if (url != null && url.getTextContent().length() > 0) {
                repoURL = url.getTextContent();
            }
            if (branchName != null && branchName.getTextContent().length() > 0) {
                branch = branchName.getTextContent();
            }
            if (credentialsId == null || credentialsId.getTextContent().length() <= 0) continue;
            repoCredentials = credentialsId.getTextContent();
        }
        if (!repoURL.equalsIgnoreCase(this.transformer.previousUrl)) {
            this.transformer.appendToScript(this.transformer.currentJobName + " - Checkout", "checkout([$class: 'GitSCM', branches: [[name: '" + branch + "']], doGenerateSubmoduleConfigurations: false, extensions: [], submoduleCfg: [], userRemoteConfigs: [[credentialsId: '" + repoCredentials + "', url: '" + repoURL + "']]])");
        }
        if (this.transformer.firstJob) {
            this.transformer.setScmURL(repoURL);
            this.transformer.setScmBranch(branch);
            this.transformer.setScmCredentialsId(repoCredentials);
        }
        this.transformer.previousUrl = repoURL;
    }

    @Override
    public void pushJenkinsfile(File workSpace, String script, String url, String branchName, String commitMessage, CredentialsProvider credentialsProvider) {
        try {
            if (branchName.startsWith("*/")) {
                branchName = branchName.replaceFirst("\\*\\/*", "");
            }
            CloneCommand cloneCommand = ((CloneCommand)new CloneCommand().setCredentialsProvider(credentialsProvider)).setDirectory(workSpace).setURI(url).setBranch(branchName);
            org.eclipse.jgit.api.Git git = cloneCommand.call();
            logger.info("Cloned repo");
            SCMUtil.writeJenkinsfile(workSpace, script);
            AddCommand addCommand = git.add();
            addCommand.addFilepattern(".");
            logger.info("Added Jenkinsfile");
            addCommand.call();
            CommitCommand commitCommand = git.commit();
            commitCommand.setMessage(commitMessage);
            commitCommand.call();
            PushCommand pushCommand = git.push();
            ((PushCommand)pushCommand.setCredentialsProvider(credentialsProvider)).setForce(true).setPushAll();
            logger.info("Pushing Jenkinsfile");
            Iterator it = pushCommand.call().iterator();
            if (it.hasNext()) {
                logger.info(((PushResult)it.next()).toString());
            }
            workSpace.deleteOnExit();
        }
        catch (Exception e) {
            logger.severe("Exception : " + e.getMessage());
            e.printStackTrace();
        }
    }

    @Override
    public Element writeCPSFlow(Document dest, String scmURL, String branch, String scmCredentialsId) {
        Element definition = dest.createElement("definition");
        definition.setAttribute("class", "org.jenkinsci.plugins.workflow.cps.CpsScmFlowDefinition");
        Element scm = dest.createElement("scm");
        scm.setAttribute("class", "hudson.plugins.git.GitSCM");
        Element configVersion = dest.createElement("configVersion");
        configVersion.setTextContent("2");
        scm.appendChild(configVersion);
        Element userRemoteConfigs = dest.createElement("userRemoteConfigs");
        Element gitUserRemoteConfigs = dest.createElement("hudson.plugins.git.UserRemoteConfig");
        Element url = dest.createElement("url");
        url.setTextContent(scmURL);
        Element cred = dest.createElement("credentialsId");
        cred.setTextContent(scmCredentialsId);
        gitUserRemoteConfigs.appendChild(url);
        gitUserRemoteConfigs.appendChild(cred);
        userRemoteConfigs.appendChild(gitUserRemoteConfigs);
        scm.appendChild(userRemoteConfigs);
        Element branches = dest.createElement("branches");
        Element branchSpec = dest.createElement("hudson.plugins.git.BranchSpec");
        Element branchName = dest.createElement("name");
        branchName.setTextContent(branch.trim());
        branchSpec.appendChild(branchName);
        branches.appendChild(branchSpec);
        scm.appendChild(branches);
        Element scriptPath = dest.createElement("scriptPath");
        scriptPath.setTextContent("Jenkinsfile");
        Element lightweight = dest.createElement("lightweight");
        lightweight.setTextContent("true");
        definition.appendChild(scm);
        definition.appendChild(scriptPath);
        definition.appendChild(lightweight);
        logger.info("Git CPS SCM flow written successfully.");
        return definition;
    }
}

