/*
 * Decompiled with CFR 0.152.
 */
package com.infostretch.labs.actions;

import com.infostretch.labs.actions.Messages;
import com.infostretch.labs.utils.ActionUtil;
import hudson.Extension;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.model.FreeStyleProject;
import hudson.model.RootAction;
import hudson.util.FormValidation;
import java.io.IOException;
import java.util.List;
import javax.servlet.ServletException;
import jenkins.model.Jenkins;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

@Extension
public class ConvertRootAction
implements RootAction,
Describable<ConvertRootAction> {
    public String getIconFileName() {
        return Messages.ConvertAction_IconName();
    }

    public String getDisplayName() {
        return Messages.ConvertRootAction_DisplayName();
    }

    public String getUrlName() {
        return Messages.ConvertAction_UrlName();
    }

    public void doConvert(StaplerRequest request, StaplerResponse response) throws ServletException, IOException {
        if (ActionUtil.validateForm(request.getParameter("newName"), request.getParameter("sourceJob"))) {
            FreeStyleProject job = (FreeStyleProject)Jenkins.getInstance().getItemByFullName(request.getParameter("sourceJob"));
            ActionUtil actionUtil = new ActionUtil(job);
            actionUtil.doConvert(request, response);
        } else {
            response.forwardToPreviousPage(request);
        }
    }

    public List listFreeStyleJobs() {
        return Jenkins.getInstance().getAllItems(FreeStyleProject.class);
    }

    public Descriptor<ConvertRootAction> getDescriptor() {
        return Jenkins.getInstance().getDescriptorOrDie(this.getClass());
    }

    @Extension
    public static final class ConvertRootActionDescriptor
    extends Descriptor<ConvertRootAction> {
        public FormValidation doCheckNewName(@QueryParameter(value="newName") String newName, @QueryParameter(value="sourceJob") String sourceJob) {
            if (sourceJob != null && sourceJob.length() > 0 && !ActionUtil.validateForm(newName, sourceJob)) {
                return FormValidation.error((String)(Messages.ConvertAction_JobExists() + " '" + ActionUtil.defineName(newName, sourceJob) + "'"));
            }
            return FormValidation.ok();
        }
    }
}

