/*
 * Decompiled with CFR 0.152.
 */
package com.infostretch.labs.actions;

import com.infostretch.labs.actions.Messages;
import com.infostretch.labs.utils.ActionUtil;
import hudson.Extension;
import hudson.model.Action;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.model.FreeStyleProject;
import hudson.util.FormValidation;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import javax.servlet.ServletException;
import jenkins.model.Jenkins;
import jenkins.model.TransientActionFactory;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public class ConvertJobAction
implements Action,
Describable<ConvertJobAction> {
    private FreeStyleProject job;

    ConvertJobAction(FreeStyleProject job) {
        this.job = job;
    }

    public String getIconFileName() {
        return Messages.ConvertAction_IconName();
    }

    public String getDisplayName() {
        return Messages.ConvertJobAction_DisplayName();
    }

    public String getUrlName() {
        return Messages.ConvertAction_UrlName();
    }

    public void doConvert(StaplerRequest request, StaplerResponse response) throws ServletException, IOException {
        if (ActionUtil.validateForm(request.getParameter("newName"), this.job.getFullName())) {
            ActionUtil actionUtil = new ActionUtil(this.job);
            actionUtil.doConvert(request, response);
        } else {
            response.forwardToPreviousPage(request);
        }
    }

    public Descriptor<ConvertJobAction> getDescriptor() {
        return Jenkins.getInstance().getDescriptorOrDie(this.getClass());
    }

    @Extension
    public static final class ConvertJobActionDescriptor
    extends Descriptor<ConvertJobAction> {
        public FormValidation doCheckNewName(@QueryParameter(value="newName") String newName, @AncestorInPath FreeStyleProject job) {
            if (!ActionUtil.validateForm(newName, job.getFullName())) {
                return FormValidation.error((String)(Messages.ConvertAction_JobExists() + " '" + ActionUtil.defineName(newName, job.getFullName()) + "'"));
            }
            return FormValidation.ok();
        }
    }

    @Extension
    public static class ActionInjector
    extends TransientActionFactory<FreeStyleProject> {
        public Collection<ConvertJobAction> createFor(FreeStyleProject p) {
            ArrayList<ConvertJobAction> list = new ArrayList<ConvertJobAction>();
            list.add(new ConvertJobAction(p));
            return list;
        }

        public Class type() {
            return FreeStyleProject.class;
        }
    }
}

