/*
 * Decompiled with CFR 0.152.
 */
package com.infostretch.labs.actions;

import com.cloudbees.hudson.plugins.folder.Folder;
import com.cloudbees.hudson.plugins.folder.TransientFolderActionFactory;
import com.infostretch.labs.actions.Messages;
import com.infostretch.labs.utils.ActionUtil;
import hudson.Extension;
import hudson.model.Action;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.model.FreeStyleProject;
import hudson.model.Item;
import hudson.model.Job;
import hudson.util.FormValidation;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.ServletException;
import jenkins.model.Jenkins;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public class ConvertFolderAction
implements Action,
Describable<ConvertFolderAction> {
    private Folder folder;

    public ConvertFolderAction(Folder folder) {
        this.folder = folder;
    }

    public String getIconFileName() {
        return Messages.ConvertAction_IconName();
    }

    public String getDisplayName() {
        return Messages.ConvertFolderAction_DisplayName();
    }

    public String getUrlName() {
        return Messages.ConvertAction_UrlName();
    }

    public Collection<? extends Job> listFreeStyleJobs() {
        return this.listFreeStyleJobs(this.folder);
    }

    public Collection listFreeStyleJobs(Folder folder) {
        HashSet jobs = new HashSet();
        for (Item i : folder.getItems()) {
            if (i.getClass().equals(FreeStyleProject.class)) {
                jobs.addAll(i.getAllJobs());
                continue;
            }
            if (!i.getClass().equals(Folder.class)) continue;
            Set subJob = (Set)this.listFreeStyleJobs((Folder)i);
            jobs.addAll(subJob);
        }
        return jobs;
    }

    public void doConvert(StaplerRequest request, StaplerResponse response) throws ServletException, IOException {
        if (ActionUtil.validateForm(request.getParameter("newName"), request.getParameter("sourceJob"))) {
            FreeStyleProject job = (FreeStyleProject)Jenkins.getInstance().getItemByFullName(request.getParameter("sourceJob"));
            ActionUtil actionUtil = new ActionUtil(job);
            actionUtil.doConvert(request, response);
        } else {
            response.forwardToPreviousPage(request);
        }
    }

    public Descriptor<ConvertFolderAction> getDescriptor() {
        return Jenkins.getInstance().getDescriptorOrDie(this.getClass());
    }

    @Extension
    public static final class ConvertFolderActionDescriptor
    extends Descriptor<ConvertFolderAction> {
        public FormValidation doCheckNewName(@QueryParameter(value="newName") String newName, @QueryParameter(value="sourceJob") String sourceJob) {
            if (sourceJob != null && sourceJob.length() > 0 && !ActionUtil.validateForm(newName, sourceJob)) {
                return FormValidation.error((String)(Messages.ConvertAction_JobExists() + " '" + ActionUtil.defineName(newName, sourceJob) + "'"));
            }
            return FormValidation.ok();
        }
    }

    @Extension
    public static class ActionFolderInjector
    extends TransientFolderActionFactory {
        public Collection<? extends Action> createFor(Folder folder) {
            ArrayList<ConvertFolderAction> list = new ArrayList<ConvertFolderAction>();
            list.add(new ConvertFolderAction(folder));
            return list;
        }
    }
}

