/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.consulkv;

import hudson.Extension;
import hudson.model.Descriptor;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.GlobalConfiguration;
import jenkins.model.GlobalPluginConfiguration;
import net.sf.json.JSONObject;
import org.jenkinsci.plugins.consulkv.ConsulKVBuilder;
import org.jenkinsci.plugins.consulkv.common.Constants;
import org.jenkinsci.plugins.consulkv.common.DebugMode;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

public class GlobalConsulConfig
extends GlobalPluginConfiguration {
    private static Logger LOGGER = Logger.getLogger(GlobalConsulConfig.class.getName());

    @Extension
    public static final class DescriptorImpl
    extends Descriptor<GlobalConfiguration> {
        private String consulHostUrl;
        private String consulAclToken;
        private String consulApiUri;
        private int consulTimeoutConnection;
        private int consulTimeoutResponse;
        private String consulTestUri;
        private DebugMode consulDebugMode;

        public DescriptorImpl() {
            this.load();
        }

        public String getConsulHostUrl() {
            return this.consulHostUrl;
        }

        public String getConsulAclToken() {
            return this.consulAclToken;
        }

        public String getConsulApiUri() {
            return this.consulApiUri;
        }

        public int getConsulTimeoutConnection() {
            return this.consulTimeoutConnection;
        }

        public int getConsulTimeoutResponse() {
            return this.consulTimeoutResponse;
        }

        public String getConsulTestUri() {
            return this.consulTestUri;
        }

        public DebugMode getConsulDebugMode() {
            return this.consulDebugMode;
        }

        public ListBoxModel doFillConsulDebugModeItems() {
            return DebugMode.getFillItems();
        }

        public DebugMode getDefaultConsulDebugMode() {
            return DebugMode.DISABLED;
        }

        public String getDisplayName() {
            return "Consul K/V Builder";
        }

        public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            JSONObject json = (JSONObject)formData.get("globalConsulConfig");
            this.consulHostUrl = json.getString("consulHostUrl");
            this.consulAclToken = json.getString("consulAclToken");
            this.consulApiUri = json.getString("consulApiUri");
            try {
                this.consulTimeoutConnection = Integer.parseInt(json.getString("consulTimeoutConnection"));
            }
            catch (NumberFormatException nfe) {
                LOGGER.warning(String.format("Using default connection timeout of %s.", Constants.TIMEOUT_CONNECTION));
                this.consulTimeoutConnection = Constants.TIMEOUT_CONNECTION;
            }
            try {
                this.consulTimeoutResponse = Integer.parseInt(json.getString("consulTimeoutResponse"));
            }
            catch (NumberFormatException nfe) {
                LOGGER.warning(String.format("Using default response timeout of %s.", Constants.TIMEOUT_RESPONSE));
                this.consulTimeoutResponse = Constants.TIMEOUT_RESPONSE;
            }
            this.consulTestUri = json.getString("consulTestUri");
            this.consulDebugMode = DebugMode.valueOf(json.getString("consulDebugMode"));
            req.bindJSON((Object)this, formData);
            this.save();
            return super.configure(req, formData);
        }

        public FormValidation doTestConnection(@QueryParameter String consulHostUrl, @QueryParameter String consulTestUri) {
            URL url;
            LOGGER.info(String.format("Testing Consul connectivity, URL = %s%s", consulHostUrl, consulTestUri));
            if (consulHostUrl.isEmpty()) {
                return FormValidation.warning((String)"Please enter a Consul host with protocol (http/https) and port.");
            }
            String URL_VALUE = consulHostUrl + consulTestUri;
            try {
                url = new URL(URL_VALUE);
            }
            catch (MalformedURLException ex) {
                String ERROR_INVALID_URL = String.format("Supplied Consul URL (%s) was invalid.", URL_VALUE);
                Logger.getLogger(ConsulKVBuilder.class.getName()).log(Level.WARNING, ERROR_INVALID_URL, ex);
                return FormValidation.error((String)ERROR_INVALID_URL);
            }
            try {
                URLConnection connection = url.openConnection();
                if (connection instanceof HttpURLConnection) {
                    HttpURLConnection httpConnection = (HttpURLConnection)connection;
                    httpConnection.setRequestMethod("HEAD");
                    int code = httpConnection.getResponseCode();
                    httpConnection.disconnect();
                    if (code >= 400) {
                        return FormValidation.error((String)"Could not connect to %s, with HEAD request. HTTP Response Code was:  %s", (Object[])new Object[]{URL_VALUE, code});
                    }
                }
            }
            catch (IOException ioe) {
                String ERROR_UNABLE_TO_CONNECT = String.format("Unable to connect to Consul at URL: %Ss", URL_VALUE);
                Logger.getLogger(ConsulKVBuilder.class.getName()).log(Level.WARNING, ERROR_UNABLE_TO_CONNECT, ioe);
                return FormValidation.error((String)"%s - %s", (Object[])new Object[]{ERROR_UNABLE_TO_CONNECT, ioe.getMessage()});
            }
            return FormValidation.ok((String)("Connected to " + consulHostUrl + consulTestUri));
        }
    }
}

