/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.datatype;

import hudson.Extension;
import hudson.RelativePath;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import hudson.util.Secret;
import io.jenkins.plugins.Cons3rtPublisher;
import io.jenkins.plugins.Cons3rtSite;
import io.jenkins.plugins.datatype.HostOption;
import io.jenkins.plugins.datatype.Property;
import io.jenkins.plugins.utils.HttpWrapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import jenkins.model.Jenkins;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class RunConfiguration
extends AbstractDescribableImpl<RunConfiguration> {
    public static final Logger LOGGER = Logger.getLogger(RunConfiguration.class.getName());
    private Integer cloudspaceId;
    private String cloudspaceName;
    private Integer deploymentId;
    private String deploymentRunName;
    private Secret password;
    private boolean releaseResources;
    private String createdUsername;
    private boolean locked;
    private boolean endExisting;
    private boolean retainOnError;
    private List<Property> properties;
    private List<HostOption> hostOptions;

    public RunConfiguration() {
    }

    @DataBoundConstructor
    public RunConfiguration(Integer deploymentId, String deploymentRunName, String cloudspaceName, boolean releaseResources, String createdUsername, Secret password, boolean locked, boolean endExisting, boolean retainOnError, List<Property> properties, List<HostOption> hostOptions) {
        this.deploymentId = deploymentId;
        this.deploymentRunName = deploymentRunName;
        this.cloudspaceName = cloudspaceName;
        this.releaseResources = releaseResources;
        this.createdUsername = createdUsername;
        this.password = password;
        this.locked = locked;
        this.endExisting = endExisting;
        this.retainOnError = retainOnError;
        this.properties = properties != null ? new ArrayList<Property>(properties) : Collections.emptyList();
        this.hostOptions = hostOptions != null ? new ArrayList<HostOption>(hostOptions) : null;
    }

    public Integer getCloudspaceId() {
        return this.cloudspaceId;
    }

    public String getCloudspaceName() {
        return this.cloudspaceName;
    }

    public Integer getDeploymentId() {
        return this.deploymentId;
    }

    public String getDeploymentRunName() {
        return this.deploymentRunName;
    }

    public Secret getPassword() {
        return this.password;
    }

    public String getCreatedUsername() {
        return this.createdUsername;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public boolean isEndExisting() {
        return this.endExisting;
    }

    public boolean isRetainOnError() {
        return this.retainOnError;
    }

    public List<Property> getProperties() {
        return this.properties;
    }

    public void setProperties(List<Property> properties) {
        this.properties = properties;
    }

    public void setLocked(boolean locked) {
        this.locked = locked;
    }

    public void setEndExisting(boolean endExisting) {
        this.endExisting = endExisting;
    }

    public void setRetainOnError(boolean retainOnError) {
        this.retainOnError = retainOnError;
    }

    public boolean isReleaseResources() {
        return this.releaseResources;
    }

    public void setCloudspaceId(Integer cloudspaceId) {
        this.cloudspaceId = cloudspaceId;
    }

    public void setCloudspaceName(String cloudspaceName) {
        this.cloudspaceName = cloudspaceName;
    }

    public void setDeploymentId(Integer deploymentId) {
        this.deploymentId = deploymentId;
    }

    public void setDeploymentRunName(String deploymentRunName) {
        this.deploymentRunName = deploymentRunName;
    }

    public void setPassword(Secret password) {
        this.password = password;
    }

    public void setReleaseResources(boolean releaseResources) {
        this.releaseResources = releaseResources;
    }

    public void setCreatedUsername(String createdUsername) {
        this.createdUsername = createdUsername;
    }

    public List<HostOption> getHostOptions() {
        return this.hostOptions;
    }

    public void setHostOptions(List<HostOption> hostOptions) {
        this.hostOptions = hostOptions;
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<RunConfiguration> {
        public String getDisplayName() {
            return "Run Configuration";
        }

        public ListBoxModel doFillCloudspaceNameItems(@QueryParameter(value="deploymentId") Integer deploymentId, Cons3rtSite site) {
            ListBoxModel m;
            block5: {
                block4: {
                    m = new ListBoxModel();
                    LOGGER.info("Calling do fill cloudspaces with dep id: " + deploymentId + " and site value: " + (site != null ? "non-null" : "null"));
                    if (!Cons3rtPublisher.getAvailableCloudspaces().containsKey(deploymentId)) break block4;
                    Set<Map.Entry<String, Integer>> cloudspaces = Cons3rtPublisher.getAvailableCloudspaces().get(deploymentId);
                    for (Map.Entry<String, Integer> cloudspace : cloudspaces) {
                        m.add(cloudspace.getKey());
                    }
                    break block5;
                }
                if (site == null || deploymentId == null) break block5;
                try {
                    Cons3rtPublisher.addAvailableCloudspaces(deploymentId, site.getAvailableCloudspaces(LOGGER, deploymentId));
                    for (Map.Entry<String, Integer> cloudspace : Cons3rtPublisher.getAvailableCloudspaces().get(deploymentId)) {
                        m.add(cloudspace.getKey());
                    }
                }
                catch (HttpWrapper.HTTPException e) {
                    LOGGER.info("Caught error fetching cloudspaces. " + e.getMessage());
                }
            }
            return m;
        }

        public FormValidation doGetCloudspaces(@QueryParameter(value="deploymentId") Integer deploymentId, @RelativePath(value="../../site") @QueryParameter String url, @RelativePath(value="../../site") @QueryParameter String tokenId, @RelativePath(value="../../site") @QueryParameter String authenticationType, @RelativePath(value="../../site") @QueryParameter String certificateId, @RelativePath(value="../../site") @QueryParameter String username) throws ServletException, IOException {
            Jenkins.getInstance().checkPermission(Item.CONFIGURE);
            if (deploymentId != null) {
                Cons3rtSite site = certificateId != null && !certificateId.isEmpty() ? new Cons3rtSite(url, tokenId, "certificate", certificateId, username) : new Cons3rtSite(url, tokenId, "username", certificateId, username);
                try {
                    Cons3rtPublisher.addAvailableCloudspaces(deploymentId, site.getAvailableCloudspaces(LOGGER, deploymentId));
                }
                catch (HttpWrapper.HTTPException e) {
                    Cons3rtPublisher.addAvailableCloudspaces(deploymentId, new HashSet<Map.Entry<String, Integer>>());
                    LOGGER.log(Level.SEVERE, e.getMessage());
                    return FormValidation.error((String)("Fetch of available cloud spaces for deployment id: " + deploymentId + " failed. " + e.getMessage()));
                }
                return FormValidation.ok((String)"Successfully Fetched Available Run Resources");
            }
            return FormValidation.error((String)"A deployment id must be provided in order to fetch available cloudspaces for the deployment.");
        }

        public FormValidation doGetResources(@QueryParameter(value="deploymentId") Integer deploymentId, @QueryParameter(value="cloudspaceName") String cloudspaceName, @RelativePath(value="../../site") @QueryParameter String url, @RelativePath(value="../../site") @QueryParameter String tokenId, @RelativePath(value="../../site") @QueryParameter String authenticationType, @RelativePath(value="../../site") @QueryParameter String certificateId, @RelativePath(value="../../site") @QueryParameter String username) throws IOException {
            Jenkins.getInstance().checkPermission(Item.CONFIGURE);
            if (deploymentId != null && cloudspaceName != null) {
                Cons3rtSite site = certificateId != null && !certificateId.isEmpty() ? new Cons3rtSite(url, tokenId, "certificate", certificateId, username) : new Cons3rtSite(url, tokenId, "username", certificateId, username);
                try {
                    Cons3rtPublisher.setAvailableRoles(site.getHostRoles(LOGGER, deploymentId));
                    Cons3rtPublisher.setAvailableNetworks(site.getAvailableNetworks(LOGGER, deploymentId, Cons3rtPublisher.getCloudspaceIdForName(cloudspaceName)));
                }
                catch (HttpWrapper.HTTPException e) {
                    LOGGER.log(Level.SEVERE, e.getMessage());
                    throw new IOException("Fetch of available host roles failed.");
                }
                return FormValidation.ok((String)"Successfully Fetched Available Run Resources");
            }
            return FormValidation.ok((String)"Successfully Fetched Available Run Resources");
        }
    }
}

