/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.datatype;

public enum PlatformType {
    LINUX("Linux"),
    OS_X("OS X"),
    SOLARIS("Solaris"),
    WINDOWS("Windows");

    private String displayName;

    private PlatformType(String displayName) {
        this.displayName = displayName;
    }

    public static PlatformType valueFromDisplayName(String displayName) {
        boolean found = false;
        PlatformType retval = null;
        for (PlatformType platform : PlatformType.values()) {
            if (!displayName.equals(platform.getDisplayName())) continue;
            retval = platform;
            found = true;
            break;
        }
        if (found) {
            return retval;
        }
        return null;
    }

    public String getDisplayName() {
        return this.displayName;
    }
}

