/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.datatype;

import hudson.Extension;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.security.Permission;
import hudson.util.ListBoxModel;
import io.jenkins.plugins.Cons3rtPublisher;
import io.jenkins.plugins.datatype.Network;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.kohsuke.stapler.DataBoundConstructor;

public class NetworkInterface
extends AbstractDescribableImpl<NetworkInterface> {
    public static final Logger LOGGER = Logger.getLogger(NetworkInterface.class.getName());
    private String networkName;
    private String internalIpAddress;
    private boolean isPrimaryConnection;
    private static Set<Network> availableCloudspaceNetworks = new HashSet<Network>();

    @DataBoundConstructor
    public NetworkInterface(String networkName, String internalIpAddress, boolean isPrimaryConnection) {
        this.networkName = networkName;
        this.isPrimaryConnection = isPrimaryConnection;
        this.internalIpAddress = internalIpAddress.isEmpty() ? null : internalIpAddress;
    }

    public String getNetworkName() {
        return this.networkName;
    }

    public void setNetworkName(String networkName) {
        this.networkName = networkName;
    }

    public static Set<Network> getAvailableCloudspaceNetworks() {
        return availableCloudspaceNetworks;
    }

    public String getInternalIpAddress() {
        return this.internalIpAddress;
    }

    public void setInternalIpAddress(String internalIpAddress) {
        this.internalIpAddress = internalIpAddress;
    }

    public boolean isPrimaryConnection() {
        return this.isPrimaryConnection;
    }

    public void setIsPrimaryConnection(boolean primaryNetwork) {
        this.isPrimaryConnection = primaryNetwork;
    }

    public static void setAvailableCloudspaceNetworks(Set<Network> availableCloudspaceNetworks) {
        NetworkInterface.availableCloudspaceNetworks = availableCloudspaceNetworks;
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<NetworkInterface> {
        public String getDisplayName() {
            return "Network Interface";
        }

        public ListBoxModel doFillNetworkNameItems() {
            Jenkins.getInstance().checkPermission(Permission.UPDATE);
            ListBoxModel m = new ListBoxModel();
            for (Network network : Cons3rtPublisher.getAvailableNetworks()) {
                m.add(network.getName());
            }
            return m;
        }
    }
}

