/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.datatype;

import hudson.Extension;
import hudson.RelativePath;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.security.Permission;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import io.jenkins.plugins.Cons3rtPublisher;
import io.jenkins.plugins.Cons3rtSite;
import io.jenkins.plugins.datatype.Disk;
import io.jenkins.plugins.datatype.NetworkInterface;
import io.jenkins.plugins.utils.HttpWrapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class HostOption
extends AbstractDescribableImpl<HostOption> {
    public static final Logger LOGGER = Logger.getLogger(HostOption.class.getName());
    private String systemRole;
    private Integer cpus;
    private Integer ram;
    private List<Disk> additionalDisks;
    private List<NetworkInterface> networkInterfaces;

    @DataBoundConstructor
    public HostOption(String systemRole, Integer cpus, Integer ram, List<Disk> additionalDisks, List<NetworkInterface> networkInterfaces) {
        this.systemRole = systemRole;
        this.cpus = cpus;
        this.ram = ram;
        this.additionalDisks = additionalDisks != null ? new ArrayList<Disk>(additionalDisks) : null;
        this.networkInterfaces = networkInterfaces != null ? new ArrayList<NetworkInterface>(networkInterfaces) : null;
    }

    public String getSystemRole() {
        return this.systemRole;
    }

    public Integer getCpus() {
        return this.cpus;
    }

    public Integer getRam() {
        return this.ram;
    }

    public List<Disk> getAdditionalDisks() {
        return this.additionalDisks;
    }

    public List<NetworkInterface> getNetworkInterfaces() {
        return this.networkInterfaces;
    }

    public void setSystemRole(String systemRole) {
        this.systemRole = systemRole;
    }

    public void setCpus(Integer cpus) {
        this.cpus = cpus;
    }

    public void setRam(Integer ram) {
        this.ram = ram;
    }

    public void setAdditionalDisks(List<Disk> additionalDisks) {
        this.additionalDisks = additionalDisks;
    }

    public void setNetworkInterfaces(List<NetworkInterface> networkInterfaces) {
        this.networkInterfaces = networkInterfaces;
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<HostOption> {
        public String getDisplayName() {
            return "Host Option";
        }

        public ListBoxModel doFillSystemRoleItems() {
            ListBoxModel m = new ListBoxModel();
            for (String role : Cons3rtPublisher.getAvailableRoles()) {
                m.add(role);
            }
            return m;
        }

        public FormValidation doGetRoles(@QueryParameter(value="deploymentId") Integer deploymentId, @RelativePath(value="../../site") @QueryParameter String url, @RelativePath(value="../../site") @QueryParameter String tokenId, @RelativePath(value="../../site") @QueryParameter String authenticationType, @RelativePath(value="../../site") @QueryParameter String certificateId, @RelativePath(value="../../site") @QueryParameter String username) {
            Jenkins.getInstance().checkPermission(Permission.UPDATE);
            Cons3rtSite site = certificateId != null && !certificateId.isEmpty() ? new Cons3rtSite(url, tokenId, "certificate", certificateId, username) : new Cons3rtSite(url, tokenId, "username", certificateId, username);
            if (site == null || deploymentId == null) {
                return FormValidation.warning((String)"Please provide a site and deployment id");
            }
            try {
                try {
                    Cons3rtPublisher.setAvailableRoles(site.getHostRoles(LOGGER, deploymentId));
                }
                catch (HttpWrapper.HTTPException e) {
                    LOGGER.log(Level.SEVERE, e.getMessage());
                    throw new IOException("Fetch of available host roles failed.");
                }
            }
            catch (IOException e) {
                LOGGER.log(Level.SEVERE, e.getMessage());
                return FormValidation.error((String)e.getMessage());
            }
            return FormValidation.ok((String)"Successfully Fetched Available Roles For Selection");
        }

        public FormValidation doGetNetworks(@QueryParameter(value="site") Cons3rtSite site, @QueryParameter(value="deploymentId") Integer deploymentId, @QueryParameter(value="cloudspaceName") String cloudspaceName) {
            Jenkins.getInstance().checkPermission(Permission.UPDATE);
            if (site == null || deploymentId == null) {
                return FormValidation.warning((String)"Please provide a site and deployment id");
            }
            try {
                try {
                    Integer cloudspaceId = Cons3rtPublisher.getCloudspaceIdForName(cloudspaceName);
                    LOGGER.log(Level.INFO, "Got cloudspace id " + cloudspaceId);
                    Cons3rtPublisher.setAvailableNetworks(site.getAvailableNetworks(LOGGER, deploymentId, cloudspaceId));
                }
                catch (HttpWrapper.HTTPException e) {
                    LOGGER.log(Level.SEVERE, e.getMessage());
                    throw new IOException("Fetch of available networks failed.");
                }
            }
            catch (IOException e) {
                LOGGER.log(Level.SEVERE, e.getMessage());
                return FormValidation.error((String)e.getMessage());
            }
            return FormValidation.ok((String)"Successfully Fetched Available Networks For Selection");
        }
    }
}

