/*
 * Decompiled with CFR 0.152.
 */
package com.myyearbook.hudson.plugins.confluence.wiki.generators;

import hudson.DescriptorExtensionList;
import hudson.ExtensionPoint;
import hudson.FilePath;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import jenkins.model.Jenkins;
import jenkins.plugins.confluence.soap.v1.RemoteAttachment;

public abstract class MarkupGenerator
implements Describable<MarkupGenerator>,
ExtensionPoint {
    public Descriptor<MarkupGenerator> getDescriptor() {
        return Jenkins.getInstance().getDescriptor(this.getClass());
    }

    public static DescriptorExtensionList<MarkupGenerator, Descriptor<MarkupGenerator>> all() {
        return Jenkins.getInstance().getDescriptorList(MarkupGenerator.class);
    }

    public abstract String generateMarkup(Run<?, ?> var1, FilePath var2, TaskListener var3, List<RemoteAttachment> var4);

    protected String expand(Run<?, ?> build, TaskListener listener, String generated, List<RemoteAttachment> remoteAttachments) {
        String result = generated;
        try {
            result = this.expandAttachmentsLink(listener, generated, remoteAttachments);
            result = build.getEnvironment(listener).expand(result);
        }
        catch (IOException e) {
            e.printStackTrace(listener.getLogger());
        }
        catch (InterruptedException e) {
            e.printStackTrace(listener.getLogger());
        }
        return result;
    }

    protected String expandAttachmentsLink(TaskListener listener, String generated, List<RemoteAttachment> remoteAttachments) {
        String result = generated;
        for (int i = 0; i < remoteAttachments.size(); ++i) {
            RemoteAttachment attachment = remoteAttachments.get(i);
            try {
                String url = attachment.getUrl();
                String href = url.substring(url.indexOf(new URI(url).getPath()));
                result = result.replace("$LINK[" + i + "]", href);
                continue;
            }
            catch (URISyntaxException e) {
                e.printStackTrace(listener.getLogger());
            }
        }
        return result;
    }
}

