/*
 * Decompiled with CFR 0.152.
 */
package com.myyearbook.hudson.plugins.confluence.wiki.generators;

import com.myyearbook.hudson.plugins.confluence.wiki.generators.MarkupGenerator;
import hudson.Extension;
import hudson.FilePath;
import hudson.Util;
import hudson.model.Descriptor;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.io.IOException;
import java.util.List;
import jenkins.plugins.confluence.soap.v1.RemoteAttachment;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.export.Exported;

public class FileGenerator
extends MarkupGenerator {
    @Exported
    public final String filename;

    @DataBoundConstructor
    public FileGenerator(String filename) {
        this.filename = Util.fixEmptyAndTrim((String)filename);
    }

    @Override
    public Descriptor<MarkupGenerator> getDescriptor() {
        return super.getDescriptor();
    }

    @Override
    public String generateMarkup(Run<?, ?> build, FilePath filePath, TaskListener listener, List<RemoteAttachment> remoteAttachments) {
        if (this.filename == null) {
            listener.getLogger().println("[confluence] No file is configured, generating empty markup.");
            return "";
        }
        FilePath markupFile = filePath.child(this.filename);
        try {
            if (markupFile.exists()) {
                return this.expand(build, listener, markupFile.readToString(), remoteAttachments);
            }
            listener.getLogger().println("[confluence] Markup file (" + markupFile.getName() + ") does not exist.");
        }
        catch (IOException e) {
            e.printStackTrace(listener.error("[confluence] Error reading input file " + this.filename));
        }
        catch (InterruptedException e) {
            e.printStackTrace(listener.error("[confluence] Error reading input file " + this.filename));
        }
        return "";
    }

    @Extension
    @Symbol(value={"confluenceFile"})
    public static class DescriptorImpl
    extends Descriptor<MarkupGenerator> {
        public String getDisplayName() {
            return "File contents";
        }
    }
}

