/*
 * Decompiled with CFR 0.152.
 */
package com.myyearbook.hudson.plugins.confluence.wiki.editors;

import com.myyearbook.hudson.plugins.confluence.wiki.generators.MarkupGenerator;
import hudson.DescriptorExtensionList;
import hudson.ExtensionPoint;
import hudson.FilePath;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.util.ArrayList;
import java.util.List;
import jenkins.model.Jenkins;
import jenkins.plugins.confluence.soap.v1.RemoteAttachment;

public abstract class MarkupEditor
implements Describable<MarkupEditor>,
ExtensionPoint {
    public MarkupGenerator generator;

    public MarkupEditor(MarkupGenerator generator) {
        this.generator = generator;
    }

    public final String performReplacement(Run<?, ?> build, FilePath filePath, TaskListener listener, String content, boolean isNewFormat, List<RemoteAttachment> remoteAttachments) throws TokenNotFoundException {
        String generated = this.generator.generateMarkup(build, filePath, listener, remoteAttachments);
        return this.performEdits(listener, content, generated, isNewFormat);
    }

    protected void log(TaskListener listener, String message) {
        listener.getLogger().println("[confluence] " + message);
    }

    protected final String unquoteToken(String token) {
        if (token == null) {
            return null;
        }
        if (token.startsWith("\"{") && token.endsWith("}\"")) {
            return token.substring(1, token.length() - 1);
        }
        return token;
    }

    protected abstract String performEdits(TaskListener var1, String var2, String var3, boolean var4) throws TokenNotFoundException;

    public Descriptor<MarkupEditor> getDescriptor() {
        return Jenkins.getInstance().getDescriptor(this.getClass());
    }

    public static DescriptorExtensionList<MarkupEditor, Descriptor<MarkupEditor>> all() {
        return Jenkins.getInstance().getDescriptorList(MarkupEditor.class);
    }

    public static class TokenNotFoundException
    extends Exception {
        private static final long serialVersionUID = -5759944314599051961L;

        public TokenNotFoundException(String message) {
            super(message);
        }

        public TokenNotFoundException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    public static abstract class MarkupEditorDescriptor
    extends Descriptor<MarkupEditor> {
        public final List<Descriptor<MarkupGenerator>> getGenerators() {
            ArrayList<Descriptor<MarkupGenerator>> generators = new ArrayList<Descriptor<MarkupGenerator>>();
            for (Descriptor generator : MarkupGenerator.all()) {
                generators.add((Descriptor<MarkupGenerator>)generator);
            }
            return generators;
        }
    }
}

