/*
 * Decompiled with CFR 0.152.
 */
package com.myyearbook.hudson.plugins.confluence.wiki.editors;

import com.myyearbook.hudson.plugins.confluence.wiki.editors.MarkupEditor;
import com.myyearbook.hudson.plugins.confluence.wiki.generators.MarkupGenerator;
import hudson.Extension;
import hudson.Util;
import hudson.model.TaskListener;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;

public class BetweenTokensEditor
extends MarkupEditor {
    public final String startMarkerToken;
    public final String endMarkerToken;

    @DataBoundConstructor
    public BetweenTokensEditor(MarkupGenerator generator, String startMarkerToken, String endMarkerToken) {
        super(generator);
        this.startMarkerToken = this.unquoteToken(Util.fixEmptyAndTrim((String)startMarkerToken));
        this.endMarkerToken = this.unquoteToken(Util.fixEmptyAndTrim((String)endMarkerToken));
    }

    @Override
    public String performEdits(TaskListener listener, String content, String generated, boolean isNewFormat) throws MarkupEditor.TokenNotFoundException {
        StringBuffer sb = new StringBuffer(content);
        int markerStart = content.indexOf(this.startMarkerToken);
        int contentStart = markerStart + this.startMarkerToken.length();
        if (markerStart < 0) {
            throw new MarkupEditor.TokenNotFoundException("Start-marker token could not be found in the page content: " + this.startMarkerToken);
        }
        int end = content.indexOf(this.endMarkerToken, contentStart);
        if (end < 0) {
            throw new MarkupEditor.TokenNotFoundException("End-marker token could not be found after the start-marker token: " + this.endMarkerToken);
        }
        sb.delete(contentStart, end);
        if (isNewFormat) {
            sb.insert(contentStart, generated);
        } else {
            sb.insert(contentStart, '\n').insert(contentStart, generated).insert(contentStart, '\n');
        }
        return sb.toString();
    }

    @Extension
    @Symbol(value={"confluenceBetweenTokens"})
    public static final class DescriptorImpl
    extends MarkupEditor.MarkupEditorDescriptor {
        public String getDisplayName() {
            return "Replace content between start/end tokens";
        }
    }
}

