/*
 * Decompiled with CFR 0.152.
 */
package com.myyearbook.hudson.plugins.confluence.wiki.editors;

import com.myyearbook.hudson.plugins.confluence.wiki.editors.MarkupEditor;
import com.myyearbook.hudson.plugins.confluence.wiki.generators.MarkupGenerator;
import hudson.Extension;
import hudson.Util;
import hudson.model.TaskListener;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;

public class BeforeTokenEditor
extends MarkupEditor {
    public final String markerToken;

    @DataBoundConstructor
    public BeforeTokenEditor(MarkupGenerator generator, String markerToken) {
        super(generator);
        this.markerToken = this.unquoteToken(Util.fixEmptyAndTrim((String)markerToken));
    }

    @Override
    public String performEdits(TaskListener listener, String content, String generated, boolean isNewFormat) throws MarkupEditor.TokenNotFoundException {
        StringBuffer sb = new StringBuffer(content);
        int start = content.indexOf(this.markerToken);
        if (start < 0) {
            throw new MarkupEditor.TokenNotFoundException("Marker token could not be located in the page content: " + this.markerToken);
        }
        if (isNewFormat) {
            sb.insert(start, generated);
        } else {
            sb.insert(start, '\n').insert(start, generated);
        }
        return sb.toString();
    }

    @Extension
    @Symbol(value={"confluenceBeforeToken"})
    public static final class DescriptorImpl
    extends MarkupEditor.MarkupEditorDescriptor {
        public String getDisplayName() {
            return "Insert content before token";
        }
    }
}

