/*
 * Decompiled with CFR 0.152.
 */
package com.myyearbook.hudson.plugins.confluence.wiki.editors;

import com.myyearbook.hudson.plugins.confluence.wiki.editors.MarkupEditor;
import com.myyearbook.hudson.plugins.confluence.wiki.generators.MarkupGenerator;
import hudson.Extension;
import hudson.Util;
import hudson.model.TaskListener;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;

public class AfterTokenEditor
extends MarkupEditor {
    public final String markerToken;

    @DataBoundConstructor
    public AfterTokenEditor(MarkupGenerator generator, String markerToken) {
        super(generator);
        this.markerToken = this.unquoteToken(Util.fixEmptyAndTrim((String)markerToken));
    }

    @Override
    public String performEdits(TaskListener listener, String content, String generated, boolean isNewFormat) throws MarkupEditor.TokenNotFoundException {
        StringBuffer sb = new StringBuffer(content);
        int start = content.indexOf(this.markerToken);
        if (start < 0) {
            throw new MarkupEditor.TokenNotFoundException("Marker token could not be located in the page content: " + this.markerToken);
        }
        int end = start + this.markerToken.length();
        if (isNewFormat) {
            sb.insert(end, generated);
        } else {
            sb.insert(end, '\n').insert(end + 1, generated);
        }
        return sb.toString();
    }

    @Extension
    @Symbol(value={"confluenceAfterToken"})
    public static final class DescriptorImpl
    extends MarkupEditor.MarkupEditorDescriptor {
        public String getDisplayName() {
            return "Insert content after token";
        }
    }
}

