/*
 * Decompiled with CFR 0.152.
 */
package com.myyearbook.hudson.plugins.confluence;

import com.myyearbook.hudson.plugins.confluence.ConfluenceSession;
import com.myyearbook.hudson.plugins.confluence.Util;
import com.myyearbook.hudson.plugins.confluence.rpc.XmlRpcClient;
import hudson.Extension;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.util.FormValidation;
import hudson.util.Secret;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import jenkins.model.Jenkins;
import jenkins.plugins.confluence.soap.v1.RemoteServerInfo;
import jenkins.plugins.confluence.soap.v2.ConfluenceSoapService;
import org.apache.axis.AxisFault;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class ConfluenceSite
implements Describable<ConfluenceSite> {
    public final URL url;
    public final String username;
    public final Secret password;
    private static final Logger LOGGER = Logger.getLogger(ConfluenceSite.class.getName());

    @DataBoundConstructor
    public ConfluenceSite(URL url, String username, String password) {
        LOGGER.log(Level.FINER, "ctor args: " + url + ", " + username + ", " + password);
        if (!url.toExternalForm().endsWith("/")) {
            try {
                url = new URL(url.toExternalForm() + "/");
            }
            catch (MalformedURLException e) {
                throw new AssertionError((Object)e);
            }
        }
        this.url = url;
        this.username = hudson.Util.fixEmptyAndTrim((String)username);
        this.password = Secret.fromString((String)password);
    }

    public ConfluenceSession createSession() throws RemoteException {
        String rpcUrl = Util.confluenceUrlToSoapUrl(this.url.toExternalForm());
        LOGGER.log(Level.FINEST, "[confluence] Using RPC url: " + rpcUrl);
        jenkins.plugins.confluence.soap.v1.ConfluenceSoapService service = XmlRpcClient.getInstance(rpcUrl);
        String token = this.username != null && this.password != null ? service.login(this.username, Secret.toString((Secret)this.password)) : "";
        RemoteServerInfo info = service.getServerInfo(token);
        ConfluenceSoapService serviceV2 = null;
        if (info.getMajorVersion() >= 4) {
            String v2Url = Util.confluenceUrlToSoapV2Url(this.url.toExternalForm());
            serviceV2 = XmlRpcClient.getV2Instance(v2Url);
        }
        return new ConfluenceSession(service, serviceV2, token, info);
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)Jenkins.getInstance().getDescriptorOrDie(this.getClass());
    }

    public String getName() {
        return this.url.getHost();
    }

    public String toString() {
        return "Confluence{" + this.getName() + "}";
    }

    @Extension
    public static final class DescriptorImpl
    extends Descriptor<ConfluenceSite> {
        public DescriptorImpl() {
            super(ConfluenceSite.class);
        }

        public FormValidation doLoginCheck(@QueryParameter String url, @QueryParameter String username, @QueryParameter String password) throws IOException {
            if ((url = hudson.Util.fixEmpty((String)url)) == null) {
                return FormValidation.ok();
            }
            username = hudson.Util.fixEmpty((String)username);
            password = hudson.Util.fixEmpty((String)password);
            if (username == null || password == null) {
                return FormValidation.warning((String)"Enter username and password");
            }
            ConfluenceSite site = new ConfluenceSite(new URL(url), username, password);
            try {
                site.createSession();
                return FormValidation.ok((String)"SUCCESS");
            }
            catch (AxisFault e) {
                LOGGER.log(Level.WARNING, "Failed to login to Confluence at " + url, e);
                return FormValidation.error((Throwable)e, (String)"Failed to login");
            }
            catch (RemoteException e) {
                LOGGER.log(Level.WARNING, "Failed to login to Confluence at " + url, e);
                return FormValidation.error((Throwable)e, (String)"Failed to login");
            }
        }

        public FormValidation doUrlCheck(final @QueryParameter String url) throws IOException, ServletException {
            if (!Jenkins.getInstance().hasPermission(Hudson.ADMINISTER)) {
                return FormValidation.ok();
            }
            final String newurl = hudson.Util.fixEmpty((String)url);
            return new FormValidation.URLCheck(){

                protected FormValidation check() throws IOException, ServletException {
                    if (newurl == null) {
                        return FormValidation.error((String)"Enter a URL");
                    }
                    try {
                        if (this.findText(this.open(new URL(newurl)), "Atlassian Confluence")) {
                            return FormValidation.ok();
                        }
                        return FormValidation.error((String)"Not a Confluence URL");
                    }
                    catch (IOException e) {
                        LOGGER.log(Level.WARNING, "Unable to connect to " + url, e);
                        return this.handleIOException(url, e);
                    }
                }
            }.check();
        }

        public String getDisplayName() {
            return "Confluence Site";
        }
    }
}

