/*
 * Decompiled with CFR 0.152.
 */
package com.myyearbook.hudson.plugins.confluence;

import hudson.Util;
import java.io.IOException;
import java.io.InputStream;
import java.rmi.RemoteException;
import javax.naming.OperationNotSupportedException;
import jenkins.plugins.confluence.soap.v1.RemoteAttachment;
import jenkins.plugins.confluence.soap.v1.RemotePageSummary;
import jenkins.plugins.confluence.soap.v1.RemoteServerInfo;
import jenkins.plugins.confluence.soap.v1.RemoteSpace;
import jenkins.plugins.confluence.soap.v2.ConfluenceSoapService;
import jenkins.plugins.confluence.soap.v2.RemotePage;
import jenkins.plugins.confluence.soap.v2.RemotePageUpdateOptions;
import jenkins.util.VirtualFile;
import org.apache.commons.io.IOUtils;

public class ConfluenceSession {
    private final jenkins.plugins.confluence.soap.v1.ConfluenceSoapService service;
    private final ConfluenceSoapService serviceV2;
    private final String token;
    private final RemoteServerInfo serverInfo;

    ConfluenceSession(jenkins.plugins.confluence.soap.v1.ConfluenceSoapService service, ConfluenceSoapService serviceV2, String token, RemoteServerInfo info) {
        this.service = service;
        this.serviceV2 = serviceV2;
        this.token = token;
        this.serverInfo = info;
    }

    public RemoteServerInfo getServerInfo() {
        return this.serverInfo;
    }

    public RemoteSpace getSpace(String spaceKey) throws RemoteException {
        return this.service.getSpace(this.token, spaceKey);
    }

    @Deprecated
    public jenkins.plugins.confluence.soap.v1.RemotePage getPage(String spaceKey, String pageKey) throws RemoteException {
        if (this.isVersion4()) {
            throw new UnsupportedOperationException("This API is not supported on Confluence version 4.0 and newer.  Use getPageSummary()");
        }
        return this.service.getPage(this.token, spaceKey, pageKey);
    }

    public RemotePageSummary getPageSummary(String spaceKey, String pageKey) throws RemoteException {
        if (!this.isVersion4()) {
            return this.getPage(spaceKey, pageKey);
        }
        return this.service.getPageSummary(this.token, spaceKey, pageKey);
    }

    public jenkins.plugins.confluence.soap.v1.RemotePage storePage(jenkins.plugins.confluence.soap.v1.RemotePage page) throws RemoteException {
        return this.service.storePage(this.token, page);
    }

    public jenkins.plugins.confluence.soap.v1.RemotePage updatePage(jenkins.plugins.confluence.soap.v1.RemotePage page, jenkins.plugins.confluence.soap.v1.RemotePageUpdateOptions options) throws RemoteException {
        return this.service.updatePage(this.token, page, options);
    }

    public RemotePage updatePageV2(RemotePage pageDataV2, RemotePageUpdateOptions options) throws RemoteException {
        return this.serviceV2.updatePage(this.token, pageDataV2, options);
    }

    public RemoteAttachment[] getAttachments(long pageId) throws RemoteException {
        return this.service.getAttachments(this.token, pageId);
    }

    public RemoteAttachment addAttachment(long pageId, String fileName, String contentType, String comment, byte[] bytes) throws RemoteException {
        RemoteAttachment attachment = new RemoteAttachment();
        attachment.setPageId(pageId);
        attachment.setFileName(ConfluenceSession.sanitizeFileName(fileName));
        attachment.setFileSize(bytes.length);
        attachment.setContentType(contentType);
        attachment.setComment(comment);
        return this.service.addAttachment(this.token, attachment, bytes);
    }

    public RemoteAttachment addAttachment(long pageId, VirtualFile file, String contentType, String comment) throws IOException, InterruptedException {
        try (InputStream is = file.open();){
            byte[] data = IOUtils.toByteArray((InputStream)is);
            RemoteAttachment remoteAttachment = this.addAttachment(pageId, file.getName(), contentType, comment, data);
            return remoteAttachment;
        }
    }

    public boolean removeAttachment(long pageId, RemoteAttachment attachment) throws jenkins.plugins.confluence.soap.v1.RemoteException, RemoteException {
        return this.service.removeAttachment(this.token, attachment.getPageId(), attachment.getFileName());
    }

    public static String sanitizeFileName(String fileName) {
        if (fileName == null) {
            return null;
        }
        return Util.fixEmptyAndTrim((String)fileName.replace('+', '_').replace('&', '_'));
    }

    public boolean isVersion4() {
        return this.serverInfo.getMajorVersion() >= 4;
    }

    public void doV4Test(long id) throws RemoteException {
        RemotePage page = this.serviceV2.getPage(this.token, id);
        System.out.println("Content: " + page.getContent());
    }

    public RemotePage getPageV2(long id) throws RemoteException {
        return this.serviceV2.getPage(this.token, id);
    }

    public boolean addLabels(long id, String labels) throws RemoteException, OperationNotSupportedException {
        if (this.serviceV2 == null) {
            throw new OperationNotSupportedException("Labels are supported as of Confluence v4 and later.");
        }
        return this.serviceV2.addLabelByName(this.token, labels, id);
    }
}

