/*
 * Decompiled with CFR 0.152.
 */
package com.myyearbook.hudson.plugins.confluence;

import com.myyearbook.hudson.plugins.confluence.ConfluenceSession;
import com.myyearbook.hudson.plugins.confluence.ConfluenceSite;
import com.myyearbook.hudson.plugins.confluence.wiki.editors.MarkupEditor;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Descriptor;
import hudson.model.EnvironmentContributingAction;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.Saveable;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Notifier;
import hudson.tasks.Publisher;
import hudson.util.DescribableList;
import hudson.util.FormValidation;
import java.io.File;
import java.io.IOException;
import java.net.URLConnection;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.naming.OperationNotSupportedException;
import jenkins.plugins.confluence.soap.v1.RemoteAttachment;
import jenkins.plugins.confluence.soap.v1.RemotePageSummary;
import jenkins.plugins.confluence.soap.v1.RemoteSpace;
import jenkins.plugins.confluence.soap.v2.RemotePage;
import jenkins.plugins.confluence.soap.v2.RemotePageUpdateOptions;
import jenkins.tasks.SimpleBuildStep;
import jenkins.util.VirtualFile;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

public final class ConfluencePublisher
extends Notifier
implements Saveable,
SimpleBuildStep {
    private static final String DEFAULT_CONTENT_TYPE = "application/octet-stream";
    @Nonnull
    private final String siteName;
    @Nonnull
    private final String spaceName;
    @Nonnull
    private final String pageName;
    private boolean attachArchivedArtifacts;
    private boolean buildIfUnstable;
    private String fileSet;
    private boolean replaceAttachments;
    private String labels;
    private long parentId;
    private DescribableList<MarkupEditor, Descriptor<MarkupEditor>> editors = new DescribableList((Saveable)this);

    @Deprecated
    public ConfluencePublisher(String siteName, boolean buildIfUnstable, String spaceName, String pageName, String labels, boolean attachArchivedArtifacts, String fileSet, List<MarkupEditor> editorList, boolean replaceAttachments, long parentId) throws IOException {
        this(siteName, spaceName, pageName);
        this.setParentId(parentId);
        this.setLabels(labels);
        this.setBuildIfUnstable(buildIfUnstable);
        this.setAttachArchivedArtifacts(attachArchivedArtifacts);
        this.setFileSet(fileSet);
        this.setReplaceAttachments(replaceAttachments);
        this.setEditorList(editorList);
    }

    @DataBoundConstructor
    public ConfluencePublisher(@Nonnull String siteName, @Nonnull String spaceName, @Nonnull String pageName) {
        List<ConfluenceSite> sites;
        if (siteName == null && (sites = this.getDescriptor().getSites()) != null && sites.size() > 0) {
            siteName = sites.get(0).getName();
        }
        this.siteName = siteName;
        this.spaceName = spaceName;
        this.pageName = pageName;
    }

    @DataBoundSetter
    public void setBuildIfUnstable(boolean buildIfUnstable) {
        this.buildIfUnstable = buildIfUnstable;
    }

    @DataBoundSetter
    public void setAttachArchivedArtifacts(boolean attachArchivedArtifacts) {
        this.attachArchivedArtifacts = attachArchivedArtifacts;
    }

    @DataBoundSetter
    public void setFileSet(String fileSet) {
        this.fileSet = StringUtils.isEmpty((String)fileSet) ? null : fileSet;
    }

    @DataBoundSetter
    public void setReplaceAttachments(boolean replaceAttachments) {
        this.replaceAttachments = replaceAttachments;
    }

    @DataBoundSetter
    public void setLabels(String labels) {
        this.labels = StringUtils.isEmpty((String)labels) ? null : labels;
    }

    @DataBoundSetter
    public void setParentId(long parentId) {
        this.parentId = parentId;
    }

    @DataBoundSetter
    public void setEditorList(List<MarkupEditor> editorList) {
        if (editorList != null) {
            this.editors.addAll(editorList);
        } else {
            this.editors.clear();
        }
    }

    public List<MarkupEditor> getEditorList() {
        return this.editors.toList();
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    public String getFileSet() {
        return this.fileSet;
    }

    @Nonnull
    public String getPageName() {
        return this.pageName;
    }

    public long getParentId() {
        return this.parentId;
    }

    public String getLabels() {
        return this.labels;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.BUILD;
    }

    public ConfluenceSite getSite() {
        List<ConfluenceSite> sites = this.getDescriptor().getSites();
        if (sites == null) {
            return null;
        }
        if (this.siteName == null && sites.size() > 0) {
            return sites.get(0);
        }
        for (ConfluenceSite site : sites) {
            if (!site.getName().equals(this.siteName)) continue;
            return site;
        }
        return null;
    }

    @Nonnull
    public String getSiteName() {
        return this.siteName;
    }

    @Nonnull
    public String getSpaceName() {
        return this.spaceName;
    }

    protected List<RemoteAttachment> performAttachments(Run build, FilePath ws, TaskListener listener, ConfluenceSession confluence, RemotePageSummary pageData) throws IOException, InterruptedException {
        RemoteAttachment[] attachments;
        String fileSet;
        long pageId = pageData.getId();
        ArrayList<RemoteAttachment> remoteAttachments = new ArrayList<RemoteAttachment>();
        if (ws == null) {
            this.log(listener, "Workspace is unavailable.");
            return remoteAttachments;
        }
        String attachmentComment = build.getEnvironment(listener).expand("Published from Jenkins build: $BUILD_URL");
        this.log(listener, "Uploading attachments to Confluence page: " + pageData.getUrl());
        ArrayList<VirtualFile> files = new ArrayList<VirtualFile>();
        if (this.attachArchivedArtifacts) {
            List artifacts = build.getArtifacts();
            if (artifacts.isEmpty()) {
                this.log(listener, "Attempting to attach the archived artifacts, but there are no archived artifacts from the job! Check job configuration...");
            } else {
                this.log(listener, "Found " + artifacts.size() + " archived artifact(s) to upload to Confluence...");
                for (Run.Artifact artifact : artifacts) {
                    files.add(build.getArtifactManager().root().child(artifact.relativePath));
                }
            }
        }
        if (!StringUtils.isEmpty((String)(fileSet = Util.fixEmptyAndTrim((String)this.fileSet)))) {
            this.log(listener, "Evaluating fileset pattern: " + fileSet);
            String artifacts = build.getEnvironment(listener).expand(fileSet);
            FilePath[] workspaceFiles = ws.list(artifacts);
            if (workspaceFiles.length > 0) {
                this.log(listener, "Found " + workspaceFiles.length + " workspace artifact(s) to upload to Confluence...");
                for (FilePath file : workspaceFiles) {
                    if (!files.contains(file)) {
                        files.add(file.toVirtualFile());
                        continue;
                    }
                    this.log(listener, " - pattern matched an archived artifact: " + file.getName());
                }
            } else {
                this.log(listener, "No files matched the pattern '" + fileSet + "'.");
                String msg = null;
                try {
                    msg = ws.validateAntFileMask(artifacts);
                }
                catch (Exception e) {
                    this.log(listener, "" + e.getMessage());
                }
                if (msg != null) {
                    this.log(listener, "" + msg);
                }
            }
        }
        this.log(listener, "Uploading " + files.size() + " file(s) to Confluence...");
        boolean shouldRemoveExistingAttachments = false;
        List<RemoteAttachment> existingAtachments = null;
        if (this.isReplaceAttachments() && (attachments = confluence.getAttachments(pageId)) != null && attachments.length > 0) {
            existingAtachments = Arrays.asList(confluence.getAttachments(pageId));
            shouldRemoveExistingAttachments = true;
        }
        for (VirtualFile file : files) {
            String contentType;
            String fileName = file.getName();
            if (shouldRemoveExistingAttachments) {
                for (RemoteAttachment remoteAttachment : existingAtachments) {
                    if (!remoteAttachment.getFileName().equals(fileName)) continue;
                    try {
                        confluence.removeAttachment(pageId, remoteAttachment);
                        existingAtachments.remove(remoteAttachment);
                        this.log(listener, "Deleted existing " + remoteAttachment.getFileName() + " from Confluence before upload new...");
                        break;
                    }
                    catch (RemoteException e) {
                        this.log(listener, "Deleting error: " + e.toString());
                        throw e;
                    }
                }
            }
            if (StringUtils.isEmpty((String)(contentType = URLConnection.guessContentTypeFromName(fileName)))) {
                contentType = DEFAULT_CONTENT_TYPE;
            }
            this.log(listener, " - Uploading file: " + fileName + " (" + contentType + ")");
            try {
                RemoteAttachment result = confluence.addAttachment(pageId, file, contentType, attachmentComment);
                remoteAttachments.add(result);
                this.log(listener, "   done: " + result.getUrl());
            }
            catch (IOException ioe) {
                listener.error("Unable to upload file...");
                ioe.printStackTrace(listener.getLogger());
            }
            catch (InterruptedException ie) {
                listener.error("Unable to upload file...");
                ie.printStackTrace(listener.getLogger());
            }
        }
        this.log(listener, "Done");
        return remoteAttachments;
    }

    public void perform(@Nonnull Run<?, ?> build, @Nonnull FilePath filePath, @Nonnull Launcher launcher, @Nonnull TaskListener listener) throws InterruptedException, IOException {
        RemotePageSummary pageData;
        boolean result = true;
        ConfluenceSite site = this.getSite();
        if (site == null) {
            this.log(listener, "Not publishing because no Confluence Site could be found. Check your Confluence configuration in system settings.");
            return;
        }
        ConfluenceSession confluence = site.createSession();
        Result buildResult = build.getResult();
        if (!this.buildIfUnstable && buildResult != null && !Result.SUCCESS.equals(buildResult)) {
            this.log(listener, "Build status is not SUCCESS (" + buildResult + ").");
            return;
        }
        EnvVarAction buildResultAction = new EnvVarAction("BUILD_RESULT", String.valueOf(buildResult));
        build.addAction((Action)buildResultAction);
        String spaceName = this.spaceName;
        String pageName = this.pageName;
        long parentId = this.parentId;
        try {
            spaceName = build.getEnvironment(listener).expand(spaceName);
            pageName = build.getEnvironment(listener).expand(pageName);
        }
        catch (IOException e) {
            e.printStackTrace(listener.getLogger());
        }
        catch (InterruptedException e) {
            e.printStackTrace(listener.getLogger());
        }
        try {
            pageData = confluence.getPageSummary(spaceName, pageName);
        }
        catch (RemoteException e) {
            this.log(listener, "Unable to locate page: " + spaceName + "/" + pageName + ".  Attempting to create the page now...");
            try {
                RemoteSpace space;
                if (parentId == 0L && (space = confluence.getSpace(spaceName)) != null) {
                    parentId = space.getHomePage();
                }
                pageData = this.createPage(confluence, spaceName, pageName, parentId);
            }
            catch (RemoteException exc2) {
                this.log(listener, "Page could not be created!  Aborting edits...");
                e.printStackTrace(listener.getLogger());
                return;
            }
        }
        String labels = this.labels;
        if (StringUtils.isNotBlank((String)labels)) {
            try {
                String expandedLabels = build.getEnvironment(listener).expand(labels);
                result &= confluence.addLabels(pageData.getId(), expandedLabels);
            }
            catch (OperationNotSupportedException e) {
                e.printStackTrace(listener.getLogger());
            }
            catch (IOException e) {
                e.printStackTrace(listener.getLogger());
            }
            catch (InterruptedException e) {
                e.printStackTrace(listener.getLogger());
            }
        }
        List<RemoteAttachment> remoteAttachments = null;
        try {
            remoteAttachments = this.performAttachments(build, filePath, listener, confluence, pageData);
        }
        catch (IOException e) {
            e.printStackTrace(listener.getLogger());
        }
        catch (InterruptedException e) {
            e.printStackTrace(listener.getLogger());
        }
        if (!this.editors.isEmpty()) {
            if (!confluence.isVersion4() && pageData instanceof jenkins.plugins.confluence.soap.v1.RemotePage) {
                try {
                    result &= this.performWikiReplacements(build, filePath, listener, confluence, (jenkins.plugins.confluence.soap.v1.RemotePage)pageData, remoteAttachments);
                }
                catch (IOException e) {
                    e.printStackTrace(listener.getLogger());
                }
                catch (InterruptedException e) {
                    e.printStackTrace(listener.getLogger());
                }
            } else {
                this.log(listener, "EXPERIMENTAL: performing storage format edits on Confluence 4.0");
                RemotePage pageDataV2 = confluence.getPageV2(pageData.getId());
                try {
                    result &= this.performWikiReplacements(build, filePath, listener, confluence, pageDataV2, remoteAttachments);
                }
                catch (IOException e) {
                    e.printStackTrace(listener.getLogger());
                }
                catch (InterruptedException e) {
                    e.printStackTrace(listener.getLogger());
                }
            }
        }
    }

    private jenkins.plugins.confluence.soap.v1.RemotePage createPage(ConfluenceSession confluence, String spaceName, String pageName, long parentId) throws RemoteException {
        jenkins.plugins.confluence.soap.v1.RemotePage newPage = new jenkins.plugins.confluence.soap.v1.RemotePage();
        newPage.setTitle(pageName);
        newPage.setSpace(spaceName);
        newPage.setContent("");
        newPage.setParentId(parentId);
        return confluence.storePage(newPage);
    }

    private boolean performWikiReplacements(Run<?, ?> build, FilePath filePath, TaskListener listener, ConfluenceSession confluence, RemotePage pageDataV2, List<RemoteAttachment> remoteAttachments) throws IOException, InterruptedException {
        String editComment = build.getEnvironment(listener).expand("Published from Jenkins build: $BUILD_URL");
        RemotePageUpdateOptions options = new RemotePageUpdateOptions(false, editComment);
        String content = this.performEdits(build, filePath, listener, pageDataV2.getContent(), true, remoteAttachments);
        pageDataV2.setContent(content);
        confluence.updatePageV2(pageDataV2, options);
        return true;
    }

    protected boolean performWikiReplacements(Run<?, ?> build, FilePath filePath, TaskListener listener, ConfluenceSession confluence, jenkins.plugins.confluence.soap.v1.RemotePage pageData, List<RemoteAttachment> remoteAttachments) throws IOException, InterruptedException {
        String editComment = build.getEnvironment(listener).expand("Published from Jenkins build: $BUILD_URL");
        jenkins.plugins.confluence.soap.v1.RemotePageUpdateOptions options = new jenkins.plugins.confluence.soap.v1.RemotePageUpdateOptions(false, editComment);
        String content = this.performEdits(build, filePath, listener, pageData.getContent(), false, remoteAttachments);
        pageData.setContent(content);
        confluence.updatePage(pageData, options);
        return true;
    }

    private String performEdits(Run<?, ?> build, FilePath filePath, TaskListener listener, String content, boolean isNewFormat, List<RemoteAttachment> remoteAttachments) {
        for (MarkupEditor editor : this.editors) {
            this.log(listener, "Performing wiki edits: " + editor.getDescriptor().getDisplayName());
            try {
                content = editor.performReplacement(build, filePath, listener, content, isNewFormat, remoteAttachments);
            }
            catch (MarkupEditor.TokenNotFoundException e) {
                this.log(listener, "ERROR while performing replacement: " + e.getMessage());
            }
        }
        return content;
    }

    private List<FilePath> findArtifacts(File artifactsDir) {
        File[] listed;
        ArrayList<FilePath> files = new ArrayList<FilePath>();
        if (artifactsDir != null && artifactsDir.isDirectory() && (listed = artifactsDir.listFiles()) != null) {
            for (File f : listed) {
                if (f == null) continue;
                if (f.isDirectory()) {
                    files.addAll(this.findArtifacts(f));
                    continue;
                }
                if (!f.isFile()) continue;
                files.add(new FilePath(f));
            }
        }
        return files;
    }

    protected void log(TaskListener listener, String message) {
        listener.getLogger().println("[confluence] " + message);
    }

    public boolean isAttachArchivedArtifacts() {
        return this.attachArchivedArtifacts;
    }

    public boolean isBuildIfUnstable() {
        return this.buildIfUnstable;
    }

    public boolean isReplaceAttachments() {
        return this.replaceAttachments;
    }

    public void save() throws IOException {
    }

    public static class EnvVarAction
    implements EnvironmentContributingAction {
        private final String name;
        private final String value;

        public EnvVarAction(String name, String value) {
            this.name = name;
            this.value = value;
        }

        public String getIconFileName() {
            return null;
        }

        public String getDisplayName() {
            return null;
        }

        public String getUrlName() {
            return null;
        }

        public void buildEnvVars(AbstractBuild<?, ?> build, EnvVars env) {
            env.put(this.name, this.value);
        }
    }

    @Extension
    @Symbol(value={"publishConfluence"})
    public static class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        private final List<ConfluenceSite> sites = new ArrayList<ConfluenceSite>();

        public DescriptorImpl() {
            super(ConfluencePublisher.class);
            this.load();
        }

        public List<Descriptor<MarkupEditor>> getEditors() {
            ArrayList<Descriptor<MarkupEditor>> editors = new ArrayList<Descriptor<MarkupEditor>>();
            for (Descriptor editor : MarkupEditor.all()) {
                editors.add((Descriptor<MarkupEditor>)editor);
            }
            return editors;
        }

        public boolean configure(StaplerRequest req, JSONObject formData) {
            this.setSites(req.bindJSONToList(ConfluenceSite.class, formData.get("sites")));
            this.save();
            return true;
        }

        public FormValidation doParentIdCheck(@QueryParameter String siteName, @QueryParameter String spaceName, @QueryParameter String parentId) {
            Long parentIdL;
            ConfluenceSite site = this.getSiteByName(siteName);
            if (Util.fixEmptyAndTrim((String)spaceName) == null || Util.fixEmptyAndTrim((String)parentId) == null) {
                return FormValidation.ok();
            }
            try {
                parentIdL = Long.valueOf(parentId);
            }
            catch (NumberFormatException nfe) {
                return FormValidation.error((String)"The parent page id should be a numeric id.");
            }
            if (site == null) {
                return FormValidation.error((String)("Unknown site:" + siteName));
            }
            try {
                ConfluenceSession confluence = site.createSession();
                RemotePage page = confluence.getPageV2(parentIdL);
                if (page != null) {
                    return FormValidation.ok((String)("OK: " + page.getTitle()));
                }
                return FormValidation.error((String)"Page not found");
            }
            catch (RemoteException re) {
                return FormValidation.warning((String)"Page not found. Check that the page still exists. ");
            }
        }

        public FormValidation doPageNameCheck(@QueryParameter String siteName, @QueryParameter String spaceName, @QueryParameter String pageName) {
            ConfluenceSite site = this.getSiteByName(siteName);
            if (Util.fixEmptyAndTrim((String)spaceName) == null || Util.fixEmptyAndTrim((String)pageName) == null) {
                return FormValidation.ok();
            }
            if (site == null) {
                return FormValidation.error((String)("Unknown site:" + siteName));
            }
            try {
                ConfluenceSession confluence = site.createSession();
                RemotePageSummary page = confluence.getPageSummary(spaceName, pageName);
                if (page != null) {
                    return FormValidation.ok((String)("OK: " + page.getTitle()));
                }
                return FormValidation.error((String)"Page not found");
            }
            catch (RemoteException re) {
                if (StringUtils.contains((String)pageName, (char)'$') || StringUtils.contains((String)spaceName, (char)'$')) {
                    return FormValidation.warning((String)"Unable to determine if the page exists because it contains build-time parameters.");
                }
                return FormValidation.warning((String)"Page not found. Check that the page still exists. If you continue, we'll try to create the page at publish-time.");
            }
        }

        public FormValidation doSpaceNameCheck(@QueryParameter String siteName, @QueryParameter String spaceName) {
            ConfluenceSite site = this.getSiteByName(siteName);
            if (Util.fixEmptyAndTrim((String)spaceName) == null) {
                return FormValidation.ok();
            }
            if (site == null) {
                return FormValidation.error((String)("Unknown site:" + siteName));
            }
            try {
                ConfluenceSession confluence = site.createSession();
                RemoteSpace space = confluence.getSpace(spaceName);
                if (space != null) {
                    return FormValidation.ok((String)("OK: " + space.getName()));
                }
                return FormValidation.error((String)"Space not found");
            }
            catch (RemoteException re) {
                if (StringUtils.contains((String)spaceName, (char)'$')) {
                    return FormValidation.warning((String)"Unable to determine if the space exists because it contains build-time parameters.");
                }
                return FormValidation.error((Throwable)re, (String)"Space not found");
            }
        }

        public String getDisplayName() {
            return "Publish to Confluence";
        }

        public ConfluenceSite getSiteByName(String siteName) {
            for (ConfluenceSite site : this.sites) {
                if (!site.getName().equals(siteName)) continue;
                return site;
            }
            return null;
        }

        public List<ConfluenceSite> getSites() {
            return Collections.unmodifiableList(this.sites);
        }

        public boolean isApplicable(Class<? extends AbstractProject> p) {
            return this.sites != null && this.sites.size() > 0;
        }

        public Publisher newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            return (Publisher)req.bindJSON(ConfluencePublisher.class, formData);
        }

        public void setSites(List<ConfluenceSite> sites) {
            this.sites.clear();
            this.sites.addAll(sites);
        }
    }
}

