/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.casc.credentials;

import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsStore;
import com.cloudbees.plugins.credentials.SystemCredentialsProvider;
import com.cloudbees.plugins.credentials.domains.Domain;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.jenkinsci.plugins.casc.Attribute;
import org.jenkinsci.plugins.casc.Configurator;
import org.jenkinsci.plugins.casc.ConfiguratorException;
import org.jenkinsci.plugins.casc.RootElementConfigurator;

@Extension(optional=true)
public class CredentialsRootConfigurator
extends Configurator<CredentialsStore>
implements RootElementConfigurator<CredentialsStore> {
    private static final Logger logger = Logger.getLogger(CredentialsRootConfigurator.class.getName());

    @Override
    public String getName() {
        return "credentials";
    }

    @Override
    public Class<CredentialsStore> getTarget() {
        return CredentialsStore.class;
    }

    @Override
    public CredentialsStore configure(Object config) throws ConfiguratorException {
        Map map = (Map)config;
        Map system = (Map)map.get("system");
        Map target = SystemCredentialsProvider.getInstance().getDomainCredentialsMap();
        target.clear();
        Configurator domainConfigurator = Configurator.lookupOrFail(Domain.class);
        Configurator credentialsConfigurator = Configurator.lookupOrFail(Credentials.class);
        for (Map.Entry dc : system.entrySet()) {
            Domain domain = (Domain)domainConfigurator.configureNonNull(dc.getKey());
            List values = (List)dc.getValue();
            ArrayList credentials = new ArrayList();
            for (Object value : values) {
                credentials.add(credentialsConfigurator.configure(value));
            }
            logger.info("Setting " + target.getClass().getCanonicalName() + "#system[" + domain.toString() + "] = " + credentials);
            target.put(domain, credentials);
        }
        return null;
    }

    @Override
    @SuppressFBWarnings(value={"DM_NEW_FOR_GETCLASS"}, justification="one can't get a parameterized type .class")
    public Set<Attribute> describe() {
        return Collections.singleton(new Attribute("system", new HashMap().getClass()));
    }
}

