/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.configfiles.xml;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import jenkins.model.Jenkins;
import org.jenkinsci.lib.configprovider.AbstractConfigProviderImpl;
import org.jenkinsci.lib.configprovider.model.Config;
import org.jenkinsci.lib.configprovider.model.ContentType;
import org.jenkinsci.plugins.configfiles.Messages;
import org.kohsuke.stapler.DataBoundConstructor;

public class XmlConfig
extends Config {
    private static final long serialVersionUID = 1L;

    @DataBoundConstructor
    public XmlConfig(String id, String name, String comment, String content) {
        super(id, name, comment, content);
    }

    public XmlConfig(String id, String name, String comment, String content, String providerId) {
        super(id, name, comment, content, providerId);
    }

    @Extension(ordinal=150.0)
    public static class XmlConfigProvider
    extends AbstractConfigProviderImpl {
        protected transient String ID_PREFIX;

        public XmlConfigProvider() {
            this.load();
        }

        @Override
        public ContentType getContentType() {
            return ContentType.DefinedType.XML;
        }

        public String getDisplayName() {
            return Messages.xml_provider_name();
        }

        @Override
        @NonNull
        public Config newConfig(@NonNull String id) {
            return new XmlConfig(id, Messages.XmlConfig_SettingsName(), Messages.XmlConfig_SettingsComment(), "<root></root>", this.getProviderId());
        }

        @Override
        protected String getXmlFileName() {
            return "xml-config-files.xml";
        }

        static {
            Jenkins.XSTREAM.alias("org.jenkinsci.plugins.configfiles.xml.XmlConfigProvider", XmlConfigProvider.class);
        }
    }
}

