/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.configfiles.folder;

import com.cloudbees.hudson.plugins.folder.AbstractFolder;
import com.cloudbees.hudson.plugins.folder.AbstractFolderProperty;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.Util;
import hudson.model.Action;
import hudson.model.Item;
import hudson.model.Job;
import hudson.security.Permission;
import hudson.util.FormValidation;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import jenkins.model.TransientActionFactory;
import net.sf.json.JSONObject;
import org.jenkinsci.lib.configprovider.ConfigProvider;
import org.jenkinsci.lib.configprovider.model.Config;
import org.jenkinsci.lib.configprovider.model.ContentType;
import org.jenkinsci.plugins.configfiles.ConfigFileStore;
import org.jenkinsci.plugins.configfiles.ConfigFilesUIContract;
import org.jenkinsci.plugins.configfiles.Messages;
import org.jenkinsci.plugins.configfiles.folder.FolderConfigFileProperty;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.HttpRedirect;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerProxy;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.interceptor.RequirePOST;
import org.kohsuke.stapler.verb.POST;

public class FolderConfigFileAction
implements Action,
ConfigFilesUIContract,
StaplerProxy {
    private AbstractFolder<?> folder;

    FolderConfigFileAction(AbstractFolder<?> folder) {
        this.folder = folder;
    }

    public AbstractFolder<?> getFolder() {
        return this.folder;
    }

    public String getIconFileName() {
        boolean hasPerm = this.folder.hasPermission(Item.CONFIGURE) || this.folder.hasPermission(Item.EXTENDED_READ) && this.hasStore();
        return hasPerm ? "symbol-cfg-logo plugin-config-file-provider" : null;
    }

    @Restricted(value={NoExternalUse.class})
    public String getIconUrl(String rootUrl) {
        if (rootUrl.endsWith("/")) {
            return rootUrl + "symbol-cfg-logo plugin-config-file-provider".substring(1);
        }
        return rootUrl + "symbol-cfg-logo plugin-config-file-provider";
    }

    public String getDisplayName() {
        return this.folder.hasPermission(Item.EXTENDED_READ) ? "Config Files" : null;
    }

    public String getUrlName() {
        return this.folder.hasPermission(Item.EXTENDED_READ) ? "configfiles" : null;
    }

    @Override
    public ContentType getContentTypeForProvider(String providerId) {
        for (ConfigProvider provider : ConfigProvider.all()) {
            if (!provider.getProviderId().equals(providerId)) continue;
            return provider.getContentType();
        }
        return null;
    }

    @Override
    public Map<ConfigProvider, Collection<Config>> getGroupedConfigs() {
        ConfigFileStore store = this.getStore();
        Map<ConfigProvider, Collection<Config>> groupedConfigs = store.getGroupedConfigs();
        return groupedConfigs;
    }

    @Override
    public List<ConfigProvider> getProviders() {
        ExtensionList<ConfigProvider> all = ConfigProvider.all();
        ArrayList<ConfigProvider> folderSupportedProviders = new ArrayList<ConfigProvider>();
        for (ConfigProvider p : all) {
            if (!p.supportsFolder()) continue;
            folderSupportedProviders.add(p);
        }
        return folderSupportedProviders;
    }

    @Override
    @POST
    public HttpResponse doSaveConfig(StaplerRequest req) throws IOException, ServletException {
        this.checkPermission(Item.CONFIGURE);
        try {
            JSONObject json = req.getSubmittedForm().getJSONObject("config");
            Config config = (Config)req.bindJSON(Config.class, json);
            if (!ID_PATTERN.matcher(config.id).matches()) {
                return FormValidation.error((String)Messages.ConfigFilesManagement_configIdContainsInvalidCharacters());
            }
            ConfigFileStore store = this.getStore();
            store.save(config);
        }
        catch (ServletException e) {
            e.printStackTrace();
        }
        return new HttpRedirect("index");
    }

    private boolean hasStore() {
        return this.folder.getProperties().get(FolderConfigFileProperty.class) != null;
    }

    ConfigFileStore getStore() {
        FolderConfigFileProperty folderConfigFileProperty = (FolderConfigFileProperty)this.folder.getProperties().get(FolderConfigFileProperty.class);
        if (folderConfigFileProperty == null) {
            folderConfigFileProperty = new FolderConfigFileProperty();
            try {
                this.folder.addProperty((AbstractFolderProperty)folderConfigFileProperty);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return folderConfigFileProperty;
    }

    @Override
    public void doShow(StaplerRequest req, StaplerResponse rsp, @QueryParameter(value="id") String configId) throws IOException, ServletException {
        this.folder.checkPermission(Item.EXTENDED_READ);
        Config config = this.getStore().getById(configId);
        req.setAttribute("contentType", (Object)config.getProvider().getContentType());
        req.setAttribute("config", (Object)config);
        req.getView((Object)this, "/org/jenkinsci/plugins/configfiles/ConfigFilesUI/show.jelly").forward((ServletRequest)req, (ServletResponse)rsp);
    }

    @Override
    public void doEditConfig(StaplerRequest req, StaplerResponse rsp, @QueryParameter(value="id") String configId) throws IOException, ServletException {
        this.checkPermission(Job.CONFIGURE);
        Config config = this.getStore().getById(configId);
        req.setAttribute("contentType", (Object)config.getProvider().getContentType());
        req.setAttribute("config", (Object)config);
        req.setAttribute("provider", (Object)config.getProvider());
        req.getView((Object)this, "/org/jenkinsci/plugins/configfiles/ConfigFilesUI/edit.jelly").forward((ServletRequest)req, (ServletResponse)rsp);
    }

    @Override
    @POST
    public void doAddConfig(StaplerRequest req, StaplerResponse rsp, @QueryParameter(value="providerId") String providerId, @QueryParameter(value="configId") String configId) throws IOException, ServletException {
        this.checkPermission(Item.CONFIGURE);
        FormValidation error = null;
        if (providerId == null || providerId.isEmpty()) {
            error = FormValidation.errorWithMarkup((String)Messages._ConfigFilesManagement_selectTypeOfFileToCreate().toString(req.getLocale()));
        }
        if (configId == null || configId.isEmpty()) {
            error = FormValidation.errorWithMarkup((String)Messages._ConfigFilesManagement_configIdCannotBeEmpty().toString(req.getLocale()));
        }
        if (!ID_PATTERN.matcher(configId).matches()) {
            error = FormValidation.error((String)Messages.ConfigFilesManagement_configIdContainsInvalidCharacters());
        }
        if (error != null) {
            req.setAttribute("error", (Object)error);
            this.checkPermission(Job.CONFIGURE);
            req.setAttribute("providers", this.getProviders());
            req.setAttribute("configId", (Object)configId);
            req.getView((Object)this, "/org/jenkinsci/plugins/configfiles/ConfigFilesUI/selectprovider.jelly").forward((ServletRequest)req, (ServletResponse)rsp);
            return;
        }
        ConfigProvider provider = ConfigProvider.getByIdOrNull(providerId);
        if (provider == null) {
            throw new IllegalArgumentException("No provider found for id '" + providerId + "'");
        }
        req.setAttribute("contentType", (Object)provider.getContentType());
        req.setAttribute("provider", (Object)provider);
        Config config = Util.isOverridden(ConfigProvider.class, ((Object)((Object)provider)).getClass(), (String)"newConfig", (Class[])new Class[]{String.class}) ? provider.newConfig(configId) : provider.newConfig();
        config.setProviderId(provider.getProviderId());
        req.setAttribute("config", (Object)config);
        req.getView((Object)this, "/org/jenkinsci/plugins/configfiles/ConfigFilesUI/edit.jelly").forward((ServletRequest)req, (ServletResponse)rsp);
    }

    @Override
    public void doSelectProvider(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        this.checkPermission(Job.CONFIGURE);
        req.setAttribute("providers", this.getProviders());
        req.setAttribute("configId", (Object)UUID.randomUUID().toString());
        req.getView((Object)this, "/org/jenkinsci/plugins/configfiles/ConfigFilesUI/selectprovider.jelly").forward((ServletRequest)req, (ServletResponse)rsp);
    }

    @Override
    @RequirePOST
    public HttpResponse doRemoveConfig(StaplerRequest res, StaplerResponse rsp, @QueryParameter(value="id") String configId) throws IOException {
        this.checkPermission(Job.CONFIGURE);
        this.getStore().remove(configId);
        return new HttpRedirect("index");
    }

    @Override
    public FormValidation doCheckConfigId(@QueryParameter(value="configId") String configId) {
        this.checkPermission(Job.CONFIGURE);
        if (configId == null || configId.isEmpty()) {
            return FormValidation.warning((String)Messages.ConfigFilesManagement_configIdCannotBeEmpty());
        }
        if (!ID_PATTERN.matcher(configId).matches()) {
            return FormValidation.error((String)Messages.ConfigFilesManagement_configIdContainsInvalidCharacters());
        }
        Config config = this.getStore().getById(configId);
        if (config == null) {
            return FormValidation.ok();
        }
        return FormValidation.warning((String)Messages.ConfigFilesManagement_configIdAlreadyUsed(config.name, config.id));
    }

    private void checkPermission(Permission permission) {
        this.folder.checkPermission(permission);
    }

    public Object getTarget() {
        this.checkPermission(Item.EXTENDED_READ);
        return this;
    }

    @Extension(optional=true)
    public static class ActionFactory
    extends TransientActionFactory<AbstractFolder> {
        public Class<AbstractFolder> type() {
            return AbstractFolder.class;
        }

        public Collection<? extends Action> createFor(AbstractFolder target) {
            return Collections.singleton(new FolderConfigFileAction(target));
        }
    }
}

