/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.configfiles.custom;

import com.cloudbees.plugins.credentials.common.IdCredentials;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.FilePath;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.jenkinsci.lib.configprovider.AbstractConfigProviderImpl;
import org.jenkinsci.lib.configprovider.model.Config;
import org.jenkinsci.lib.configprovider.model.ContentType;
import org.jenkinsci.plugins.configfiles.custom.security.CustomConfigCredentialsHelper;
import org.jenkinsci.plugins.configfiles.custom.security.HasCustomizedCredentialMappings;

public abstract class AbstractCustomProvider
extends AbstractConfigProviderImpl {
    @Override
    public ContentType getContentType() {
        return ContentType.DefinedType.SHELL;
    }

    @Override
    public String supplyContent(Config configFile, Run<?, ?> build, FilePath workDir, TaskListener listener, List<String> tempFiles) throws IOException {
        HasCustomizedCredentialMappings settings = (HasCustomizedCredentialMappings)((Object)configFile);
        Map<String, IdCredentials> resolvedCredentials = CustomConfigCredentialsHelper.resolveCredentials(build, settings.getCustomizedCredentialMappings(), listener);
        String fileContent = super.supplyContent(configFile, build, workDir, listener, tempFiles);
        if (!resolvedCredentials.isEmpty()) {
            try {
                fileContent = CustomConfigCredentialsHelper.fillAuthentication(build, workDir, listener, fileContent, resolvedCredentials);
            }
            catch (Exception exception) {
                throw new IOException("[ERROR] could not insert credentials into the settings file " + configFile, exception);
            }
        }
        return fileContent;
    }

    @Override
    @NonNull
    public List<String> getSensitiveContentForMasking(Config configFile, Run<?, ?> build) {
        HasCustomizedCredentialMappings settings = (HasCustomizedCredentialMappings)((Object)configFile);
        return CustomConfigCredentialsHelper.secretsForMasking(build, settings.getCustomizedCredentialMappings());
    }
}

