/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.configfiles.buildwrapper;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.console.ConsoleLogFilter;
import hudson.model.AbstractProject;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildWrapperDescriptor;
import hudson.util.Secret;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import jenkins.tasks.SimpleBuildWrapper;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.Symbol;
import org.jenkinsci.lib.configprovider.model.Config;
import org.jenkinsci.plugins.configfiles.ConfigFiles;
import org.jenkinsci.plugins.configfiles.buildwrapper.ManagedFile;
import org.jenkinsci.plugins.configfiles.buildwrapper.ManagedFileUtil;
import org.jenkinsci.plugins.configfiles.buildwrapper.Messages;
import org.jenkinsci.plugins.credentialsbinding.masking.SecretPatterns;
import org.kohsuke.stapler.DataBoundConstructor;

public class ConfigFileBuildWrapper
extends SimpleBuildWrapper {
    private List<ManagedFile> managedFiles = new ArrayList<ManagedFile>();

    @DataBoundConstructor
    public ConfigFileBuildWrapper(List<ManagedFile> managedFiles) {
        this.managedFiles = managedFiles;
    }

    public void setUp(SimpleBuildWrapper.Context context, Run<?, ?> build, FilePath workspace, Launcher launcher, TaskListener listener, EnvVars initialEnvironment) throws IOException, InterruptedException {
        ArrayList<String> tempFiles = new ArrayList<String>();
        Map<ManagedFile, FilePath> file2Path = ManagedFileUtil.provisionConfigFiles(this.managedFiles, initialEnvironment, build, workspace, listener, tempFiles);
        for (Map.Entry<ManagedFile, FilePath> entry : file2Path.entrySet()) {
            boolean noTargetGiven;
            ManagedFile mf = entry.getKey();
            FilePath fp = entry.getValue();
            if (!StringUtils.isBlank((String)mf.variable)) {
                context.env(mf.variable, fp.getRemote());
            }
            if (!(noTargetGiven = StringUtils.isBlank((String)entry.getKey().getTargetLocation()))) continue;
            tempFiles.add(entry.getValue().getRemote());
        }
        if (!tempFiles.isEmpty()) {
            context.setDisposer((SimpleBuildWrapper.Disposer)new TempFileCleaner(tempFiles));
        }
    }

    private synchronized List<String> getSecretValuesToMask(Run<?, ?> build) {
        ArrayList<String> seecretsToMask = new ArrayList<String>();
        for (ManagedFile managedFile : this.managedFiles) {
            Object config = ConfigFiles.getByIdOrNull(build, managedFile.getFileId());
            seecretsToMask.addAll(((Config)config).getProvider().getSensitiveContentForMasking((Config)config, build));
        }
        return seecretsToMask;
    }

    public ConsoleLogFilter createLoggerDecorator(@NonNull Run<?, ?> build) {
        List<String> secretValues = this.getSecretValuesToMask(build);
        if (secretValues.isEmpty()) {
            return null;
        }
        return new SecretFilter(secretValues, build.getCharset());
    }

    public List<ManagedFile> getManagedFiles() {
        return this.managedFiles;
    }

    private static class TempFileCleaner
    extends SimpleBuildWrapper.Disposer {
        private static final Logger LOGGER = Logger.getLogger(TempFileCleaner.class.getName());
        private static final long serialVersionUID = 1L;
        private final List<String> tempFiles;

        TempFileCleaner(List<String> tempFiles) {
            this.tempFiles = tempFiles;
        }

        public void tearDown(Run<?, ?> build, FilePath workspace, Launcher launcher, TaskListener listener) throws IOException, InterruptedException {
            listener.getLogger().println("Deleting " + this.tempFiles.size() + " temporary files");
            for (String tempFile : this.tempFiles) {
                LOGGER.log(Level.FINE, "Delete: {0}", new Object[]{tempFile});
                new FilePath(workspace, tempFile).delete();
            }
        }
    }

    private static final class SecretFilter
    extends ConsoleLogFilter
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private Secret pattern;
        private String charset;

        SecretFilter(Collection<String> secrets, Charset cs) {
            this.pattern = Secret.fromString((String)SecretPatterns.getAggregateSecretPattern(secrets).pattern());
            this.charset = cs.name();
        }

        public OutputStream decorateLogger(Run build, OutputStream logger) {
            return new SecretPatterns.MaskingOutputStream(logger, () -> Pattern.compile(this.pattern.getPlainText()), this.charset);
        }
    }

    @Symbol(value={"configFileProvider"})
    @Extension(ordinal=50.0)
    public static final class DescriptorImpl
    extends BuildWrapperDescriptor {
        public String getDisplayName() {
            return Messages.display_name();
        }

        public boolean isApplicable(AbstractProject<?, ?> item) {
            return true;
        }
    }
}

