/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.configfiles.maven.security;

import com.cloudbees.plugins.credentials.common.StandardUsernameCredentials;
import com.cloudbees.plugins.credentials.common.StandardUsernameListBoxModel;
import hudson.Extension;
import hudson.model.AbstractDescribableImpl;
import hudson.model.AbstractProject;
import hudson.model.Descriptor;
import hudson.util.ListBoxModel;
import java.util.List;
import org.jenkinsci.plugins.configfiles.maven.security.CredentialsHelper;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerCredentialMapping
extends AbstractDescribableImpl<ServerCredentialMapping> {
    private final String serverId;
    private final String credentialsId;
    private static final DescriptorImpl DESCIPTOR = new DescriptorImpl();

    @DataBoundConstructor
    public ServerCredentialMapping(String serverId, String credentialsId) {
        this.serverId = serverId;
        this.credentialsId = credentialsId;
    }

    public String getServerId() {
        return this.serverId;
    }

    public String getCredentialsId() {
        return this.credentialsId;
    }

    public Descriptor<ServerCredentialMapping> getDescriptor() {
        return DESCIPTOR;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static class DescriptorImpl
    extends Descriptor<ServerCredentialMapping> {
        public ListBoxModel doFillCredentialsIdItems(@AncestorInPath AbstractProject<?, ?> context, @QueryParameter String serverId) {
            List<StandardUsernameCredentials> validCredentials = CredentialsHelper.findValidCredentials(serverId);
            return new StandardUsernameListBoxModel().withEmptySelection().withAll(validCredentials);
        }

        public String getDisplayName() {
            return "";
        }
    }
}

