/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.configfiles.maven.security;

import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardUsernameCredentials;
import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import com.cloudbees.plugins.credentials.domains.DomainRequirement;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.security.ACL;
import hudson.util.Secret;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import jenkins.model.Jenkins;
import org.acegisecurity.Authentication;
import org.jenkinsci.plugins.configfiles.maven.security.MavenServerIdRequirement;
import org.jenkinsci.plugins.configfiles.maven.security.ServerCredentialMapping;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CredentialsHelper {
    private static final Logger LOGGER = Logger.getLogger(CredentialsHelper.class.getName());

    private CredentialsHelper() {
    }

    public static Map<String, StandardUsernameCredentials> resolveCredentials(Item item, List<ServerCredentialMapping> serverCredentialMappings) {
        HashMap<String, StandardUsernameCredentials> serverId2credential = new HashMap<String, StandardUsernameCredentials>();
        for (ServerCredentialMapping serverCredentialMapping : serverCredentialMappings) {
            String credentialsId = serverCredentialMapping.getCredentialsId();
            String serverId = serverCredentialMapping.getServerId();
            List<StandardUsernameCredentials> foundCredentials = CredentialsHelper.findValidCredentials(serverId);
            StandardUsernameCredentials c = (StandardUsernameCredentials)CredentialsMatchers.firstOrNull(foundCredentials, (CredentialsMatcher)CredentialsMatchers.withId((String)credentialsId));
            if (c == null) continue;
            serverId2credential.put(serverId, c);
        }
        return serverId2credential;
    }

    public static List<StandardUsernameCredentials> findValidCredentials(String serverIdPattern) {
        List foundCredentials = CredentialsProvider.lookupCredentials(StandardUsernameCredentials.class, (ItemGroup)Jenkins.getInstance(), (Authentication)ACL.SYSTEM, (DomainRequirement[])new DomainRequirement[]{new MavenServerIdRequirement(serverIdPattern)});
        return foundCredentials;
    }

    public static String fillAuthentication(String settingsContent, Map<String, StandardUsernameCredentials> serverId2credential) throws Exception {
        String content = settingsContent;
        if (!serverId2credential.isEmpty()) {
            Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new InputSource(new StringReader(content)));
            Set<Map.Entry<String, StandardUsernameCredentials>> credentialEntries = serverId2credential.entrySet();
            XPath xpath = XPathFactory.newInstance().newXPath();
            Node serversNode = (Node)xpath.evaluate("/settings/servers", doc, XPathConstants.NODE);
            if (serversNode == null) {
                Node settingsNode = (Node)xpath.evaluate("/settings", doc, XPathConstants.NODE);
                serversNode = doc.createElement("servers");
                settingsNode.appendChild(serversNode);
            } else {
                CredentialsHelper.removeAllChilds(serversNode);
            }
            for (Map.Entry<String, StandardUsernameCredentials> srvId2credential : credentialEntries) {
                StandardUsernameCredentials credential = srvId2credential.getValue();
                if (credential instanceof StandardUsernamePasswordCredentials) {
                    StandardUsernamePasswordCredentials userPwd = (StandardUsernamePasswordCredentials)credential;
                    LOGGER.fine("add: " + srvId2credential.getKey() + " -> " + userPwd);
                    Element server = doc.createElement("server");
                    Element id = doc.createElement("id");
                    id.setTextContent(srvId2credential.getKey());
                    Element password = doc.createElement("password");
                    password.setTextContent(Secret.toString((Secret)userPwd.getPassword()));
                    Element username = doc.createElement("username");
                    username.setTextContent(userPwd.getUsername());
                    server.appendChild(id);
                    server.appendChild(username);
                    server.appendChild(password);
                    serversNode.appendChild(server);
                    continue;
                }
                Object[] params = new Object[]{srvId2credential.getKey(), credential.getClass()};
                LOGGER.log(Level.SEVERE, "credentials for {0} of type {1} not (yet) supported", params);
            }
            StringWriter writer = new StringWriter();
            Transformer xformer = TransformerFactory.newInstance().newTransformer();
            xformer.transform(new DOMSource(doc), new StreamResult(writer));
            content = writer.toString();
        }
        return content;
    }

    private static void removeAllChilds(Node serverNode) {
        NodeList childNodes = serverNode.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node child = childNodes.item(i);
            serverNode.removeChild(child);
            --i;
        }
    }
}

