/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.configfiles.maven.job;

import com.cloudbees.plugins.credentials.common.StandardUsernameCredentials;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.FilePath;
import hudson.model.AbstractBuild;
import hudson.model.Action;
import hudson.model.Item;
import hudson.model.TaskListener;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import jenkins.model.Jenkins;
import jenkins.mvn.SettingsProvider;
import jenkins.mvn.SettingsProviderDescriptor;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.lib.configprovider.model.Config;
import org.jenkinsci.plugins.configfiles.Util;
import org.jenkinsci.plugins.configfiles.common.CleanTempFilesAction;
import org.jenkinsci.plugins.configfiles.maven.MavenSettingsConfig;
import org.jenkinsci.plugins.configfiles.maven.job.SimpleEnvironment;
import org.jenkinsci.plugins.configfiles.maven.security.CredentialsHelper;
import org.jenkinsci.plugins.configfiles.maven.security.ServerCredentialMapping;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MvnSettingsProvider
extends SettingsProvider {
    private String settingsConfigId;

    @Deprecated
    public MvnSettingsProvider() {
    }

    @DataBoundConstructor
    public MvnSettingsProvider(String settingsConfigId) {
        this.settingsConfigId = settingsConfigId;
    }

    public String getSettingsConfigId() {
        return this.settingsConfigId;
    }

    public void setSettingsConfigId(String settingsConfigId) {
        this.settingsConfigId = settingsConfigId;
    }

    public FilePath supplySettings(AbstractBuild<?, ?> build, TaskListener listener) {
        if (StringUtils.isNotBlank((String)this.settingsConfigId)) {
            MavenSettingsConfig.MavenSettingsConfigProvider provider = (MavenSettingsConfig.MavenSettingsConfigProvider)((Object)Util.getProviderForConfigIdOrNull(this.settingsConfigId));
            Config c = provider.getConfigById(this.settingsConfigId);
            if (c == null) {
                listener.getLogger().println("ERROR: your Apache Maven build is setup to use a config with id " + this.settingsConfigId + " but can not find the config");
            } else {
                MavenSettingsConfig config = null;
                config = c instanceof MavenSettingsConfig ? (MavenSettingsConfig)c : new MavenSettingsConfig(c.id, c.name, c.comment, c.content, null);
                listener.getLogger().println("using settings config with name " + config.name);
                if (StringUtils.isNotBlank((String)config.content)) {
                    try {
                        String fileContent = config.content;
                        List<ServerCredentialMapping> serverCredentialMappings = config.getServerCredentialMappings();
                        Map<String, StandardUsernameCredentials> resolvedCredentials = CredentialsHelper.resolveCredentials((Item)build.getProject(), serverCredentialMappings);
                        if (!resolvedCredentials.isEmpty()) {
                            fileContent = CredentialsHelper.fillAuthentication(fileContent, resolvedCredentials);
                        }
                        FilePath f = MvnSettingsProvider.copyConfigContentToFilePath(fileContent, build.getWorkspace());
                        build.getEnvironments().add((Object)new SimpleEnvironment("MVN_SETTINGS", f.getRemote()));
                        build.addAction((Action)new CleanTempFilesAction(f.getRemote()));
                        return f;
                    }
                    catch (Exception e) {
                        throw new IllegalStateException("the settings.xml could not be supplied for the current build: " + e.getMessage(), e);
                    }
                }
            }
        }
        return null;
    }

    public static FilePath copyConfigContentToFilePath(String content, FilePath workspace) throws IOException, InterruptedException {
        return workspace.createTextTempFile("settings", ".xml", content, false);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension(ordinal=10.0)
    public static class DescriptorImpl
    extends SettingsProviderDescriptor {
        public String getDisplayName() {
            return "provided settings.xml";
        }

        public Collection<Config> getAllMavenSettingsConfigs() {
            ExtensionList configProviders = Jenkins.getInstance().getExtensionList(MavenSettingsConfig.MavenSettingsConfigProvider.class);
            if (configProviders != null && configProviders.size() > 0) {
                return ((MavenSettingsConfig.MavenSettingsConfigProvider)((Object)configProviders.get(0))).getAllConfigs();
            }
            return Collections.emptyList();
        }
    }
}

