/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.configfiles.maven;

import hudson.Extension;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.jenkinsci.lib.configprovider.AbstractConfigProviderImpl;
import org.jenkinsci.lib.configprovider.model.Config;
import org.jenkinsci.lib.configprovider.model.ContentType;
import org.jenkinsci.plugins.configfiles.Messages;

public class MavenToolchainsConfig
extends Config {
    private static final long serialVersionUID = 1L;

    public MavenToolchainsConfig(String id, String name, String comment, String content) {
        super(id, name, comment, content);
    }

    @Extension(ordinal=180.0)
    public static class MavenToolchainsConfigProvider
    extends AbstractConfigProviderImpl {
        public MavenToolchainsConfigProvider() {
            this.load();
        }

        public ContentType getContentType() {
            return ContentType.DefinedType.XML;
        }

        public String getDisplayName() {
            return Messages.mvn_toolchains_provider_name();
        }

        protected String getXmlFileName() {
            return "maven-toolchains-files.xml";
        }

        public Config newConfig() {
            String id = this.getProviderId() + System.currentTimeMillis();
            return new Config(id, "MyToolchains", "", this.loadTemplateContent());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String loadTemplateContent() {
            String tpl;
            try {
                InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("toolchains-tpl.xml");
                StringBuilder sb = new StringBuilder(Math.max(16, is.available()));
                char[] tmp = new char[4096];
                try {
                    int cnt;
                    InputStreamReader reader = new InputStreamReader(is, "UTF-8");
                    while ((cnt = reader.read(tmp)) > 0) {
                        sb.append(tmp, 0, cnt);
                    }
                }
                finally {
                    is.close();
                }
                tpl = sb.toString();
            }
            catch (Exception e) {
                tpl = "<toolchains></toolchains>";
            }
            return tpl;
        }
    }
}

