/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.configfiles.maven;

import hudson.Extension;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import jenkins.model.Jenkins;
import org.jenkinsci.lib.configprovider.model.Config;
import org.jenkinsci.lib.configprovider.model.ContentType;
import org.jenkinsci.plugins.configfiles.Messages;
import org.jenkinsci.plugins.configfiles.maven.AbstractMavenSettingsProvider;
import org.jenkinsci.plugins.configfiles.maven.security.HasServerCredentialMappings;
import org.jenkinsci.plugins.configfiles.maven.security.ServerCredentialMapping;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MavenSettingsConfig
extends Config
implements HasServerCredentialMappings {
    private static final long serialVersionUID = 1L;
    private List<ServerCredentialMapping> serverCredentialMappings;

    @DataBoundConstructor
    public MavenSettingsConfig(String id, String name, String comment, String content, List<ServerCredentialMapping> serverCredentialMappings) {
        super(id, name, comment, content);
        this.serverCredentialMappings = serverCredentialMappings == null ? new ArrayList() : serverCredentialMappings;
    }

    @Override
    public List<ServerCredentialMapping> getServerCredentialMappings() {
        return this.serverCredentialMappings == null ? new ArrayList() : this.serverCredentialMappings;
    }

    @Extension(ordinal=190.0)
    public static class MavenSettingsConfigProvider
    extends AbstractMavenSettingsProvider {
        protected transient String ID_PREFIX;

        public MavenSettingsConfigProvider() {
            this.load();
        }

        public ContentType getContentType() {
            return ContentType.DefinedType.XML;
        }

        public String getDisplayName() {
            return Messages.mvn_settings_provider_name();
        }

        public Config newConfig() {
            String id = this.getProviderId() + System.currentTimeMillis();
            return new MavenSettingsConfig(id, "MySettings", "user settings", this.loadTemplateContent(), Collections.<ServerCredentialMapping>emptyList());
        }

        public boolean isResponsibleFor(String configId) {
            return super.isResponsibleFor(configId) || configId.startsWith("DefaultMavenSettingsProvider.");
        }

        protected String getXmlFileName() {
            return "maven-settings-files.xml";
        }

        static {
            Jenkins.XSTREAM.alias("org.jenkinsci.plugins.configfiles.maven.DefaultMavenSettingsProvider", MavenSettingsConfigProvider.class);
        }
    }
}

