/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.configfiles.maven;

import hudson.Extension;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import jenkins.model.Jenkins;
import org.jenkinsci.lib.configprovider.model.Config;
import org.jenkinsci.lib.configprovider.model.ContentType;
import org.jenkinsci.plugins.configfiles.Messages;
import org.jenkinsci.plugins.configfiles.maven.AbstractMavenSettingsProvider;
import org.jenkinsci.plugins.configfiles.maven.security.HasServerCredentialMappings;
import org.jenkinsci.plugins.configfiles.maven.security.ServerCredentialMapping;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GlobalMavenSettingsConfig
extends Config
implements HasServerCredentialMappings {
    private static final long serialVersionUID = 1L;
    private List<ServerCredentialMapping> serverCredentialMappings;

    @DataBoundConstructor
    public GlobalMavenSettingsConfig(String id, String name, String comment, String content, List<ServerCredentialMapping> serverCredentialMappings) {
        super(id, name, comment, content);
        this.serverCredentialMappings = serverCredentialMappings == null ? new ArrayList() : serverCredentialMappings;
    }

    public GlobalMavenSettingsConfig(String id, String name, String comment, String content) {
        super(id, name, comment, content);
    }

    @Override
    public List<ServerCredentialMapping> getServerCredentialMappings() {
        return this.serverCredentialMappings;
    }

    @Extension(ordinal=200.0)
    public static class GlobalMavenSettingsConfigProvider
    extends AbstractMavenSettingsProvider {
        protected transient String ID_PREFIX;

        public GlobalMavenSettingsConfigProvider() {
            this.load();
        }

        public ContentType getContentType() {
            return ContentType.DefinedType.XML;
        }

        public String getDisplayName() {
            return Messages.mvn_global_settings_provider_name();
        }

        public Config newConfig() {
            String id = this.getProviderId() + System.currentTimeMillis();
            return new GlobalMavenSettingsConfig(id, "MyGlobalSettings", "global settings", this.loadTemplateContent(), Collections.<ServerCredentialMapping>emptyList());
        }

        public boolean isResponsibleFor(String configId) {
            return super.isResponsibleFor(configId) || configId.startsWith("DefaultGlobalMavenSettingsProvider.");
        }

        protected String getXmlFileName() {
            return "maven-global-settings-files.xml";
        }

        static {
            Jenkins.XSTREAM.alias("org.jenkinsci.plugins.configfiles.maven.DefaultGlobalMavenSettingsProvider", GlobalMavenSettingsConfigProvider.class);
        }
    }
}

