/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.configfiles.json;

import hudson.Extension;
import org.jenkinsci.lib.configprovider.AbstractConfigProviderImpl;
import org.jenkinsci.lib.configprovider.model.Config;
import org.jenkinsci.lib.configprovider.model.ContentType;
import org.jenkinsci.plugins.configfiles.Messages;
import org.kohsuke.stapler.DataBoundConstructor;

public class JsonConfig
extends Config {
    private static final long serialVersionUID = 1L;

    @DataBoundConstructor
    public JsonConfig(String id, String name, String comment, String content) {
        super(id, name, comment, JsonConfig.fixJsonContent(content));
    }

    private static String fixJsonContent(String content) {
        String c = content.trim();
        if (c.startsWith("\"") && c.endsWith("\"")) {
            return c.substring(1, c.length() - 1);
        }
        return c;
    }

    @Extension(ordinal=180.0)
    public static class JsonConfigProvider
    extends AbstractConfigProviderImpl {
        public JsonConfigProvider() {
            this.load();
        }

        public ContentType getContentType() {
            return new ContentType(){

                public String getCmMode() {
                    return "javascript";
                }

                public String getMime() {
                    return "application/json";
                }
            };
        }

        public String getDisplayName() {
            return Messages.json_provider_name();
        }

        public JsonConfig getConfigById(String configId) {
            Config c = super.getConfigById(configId);
            return new JsonConfig(c.id, c.name, c.comment, c.content);
        }

        public Config newConfig() {
            String id = this.getProviderId() + System.currentTimeMillis();
            return new Config(id, "JsonConfig", "", "{}");
        }
    }
}

