/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.configfiles.common;

import hudson.EnvVars;
import hudson.FilePath;
import hudson.model.AbstractBuild;
import hudson.model.EnvironmentContributingAction;
import hudson.model.InvisibleAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.configfiles.buildwrapper.ManagedFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CleanTempFilesAction
extends InvisibleAction
implements EnvironmentContributingAction {
    private transient List<String> explicitTempFiles = new ArrayList<String>();
    private transient Map<ManagedFile, FilePath> file2Path = new HashMap<ManagedFile, FilePath>();

    public CleanTempFilesAction(Map<ManagedFile, FilePath> file2Path) {
        this.file2Path = file2Path == null ? Collections.emptyMap() : file2Path;
        this.explicitTempFiles = Collections.emptyList();
    }

    public CleanTempFilesAction(String tempfile) {
        this.file2Path = Collections.emptyMap();
        this.explicitTempFiles = new ArrayList<String>();
        this.explicitTempFiles.add(tempfile);
    }

    private Object readResolve() {
        this.file2Path = Collections.emptyMap();
        this.explicitTempFiles = Collections.emptyList();
        return this;
    }

    public void buildEnvVars(AbstractBuild<?, ?> build, EnvVars env) {
        for (Map.Entry<ManagedFile, FilePath> entry : this.file2Path.entrySet()) {
            ManagedFile mf = entry.getKey();
            FilePath fp = entry.getValue();
            if (StringUtils.isBlank((String)mf.variable)) continue;
            env.put(mf.variable, fp.getRemote());
        }
    }

    List<String> getTempFiles() {
        ArrayList<String> tempFiles = new ArrayList<String>();
        for (Map.Entry<ManagedFile, FilePath> entry : this.file2Path.entrySet()) {
            boolean noTargetGiven = StringUtils.isBlank((String)entry.getKey().targetLocation);
            if (!noTargetGiven) continue;
            tempFiles.add(entry.getValue().getRemote());
        }
        if (this.explicitTempFiles != null) {
            tempFiles.addAll(this.explicitTempFiles);
        }
        return tempFiles;
    }
}

