/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.configfiles.buildwrapper;

import com.cloudbees.plugins.credentials.common.StandardUsernameCredentials;
import hudson.FilePath;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Item;
import hudson.model.TaskListener;
import hudson.remoting.Callable;
import hudson.remoting.VirtualChannel;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.lib.configprovider.ConfigProvider;
import org.jenkinsci.lib.configprovider.model.Config;
import org.jenkinsci.plugins.configfiles.buildwrapper.ManagedFile;
import org.jenkinsci.plugins.configfiles.buildwrapper.Messages;
import org.jenkinsci.plugins.configfiles.maven.security.CredentialsHelper;
import org.jenkinsci.plugins.configfiles.maven.security.HasServerCredentialMappings;
import org.jenkinsci.plugins.tokenmacro.MacroEvaluationException;
import org.jenkinsci.plugins.tokenmacro.TokenMacro;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManagedFileUtil {
    public static FilePath createTempFile(VirtualChannel channel) throws IOException, InterruptedException {
        return (FilePath)channel.call((Callable)new Callable<FilePath, IOException>(){
            private static final long serialVersionUID = 1L;

            public FilePath call() throws IOException {
                File tmpTarget = File.createTempFile("config", "tmp");
                return new FilePath(tmpTarget);
            }
        });
    }

    public static Map<ManagedFile, FilePath> provisionConfigFiles(List<ManagedFile> managedFiles, AbstractBuild<?, ?> build, BuildListener listener) throws IOException, InterruptedException {
        HashMap<ManagedFile, FilePath> file2Path = new HashMap<ManagedFile, FilePath>();
        listener.getLogger().println("provisoning config files...");
        for (ManagedFile managedFile : managedFiles) {
            ConfigProvider provider = ManagedFileUtil.getProviderForConfigId(managedFile.fileId);
            if (provider == null) {
                throw new IOException("not able to resolve a provider responsible for the following file - maybe a config-file-provider plugin got deleted by an administrator: " + managedFile);
            }
            Config configFile = provider.getConfigById(managedFile.fileId);
            if (configFile == null) {
                throw new IOException("not able to provide the following file, can't be resolved by any provider - maybe it got deleted by an administrator: " + managedFile);
            }
            boolean createTempFile = StringUtils.isBlank((String)managedFile.targetLocation);
            FilePath target = null;
            if (createTempFile) {
                target = ManagedFileUtil.createTempFile(build.getWorkspace().getChannel());
            } else {
                String expandedTargetLocation = managedFile.targetLocation;
                try {
                    expandedTargetLocation = TokenMacro.expandAll(build, (TaskListener)listener, (String)managedFile.targetLocation);
                }
                catch (MacroEvaluationException e) {
                    listener.getLogger().println("[ERROR] failed to expand variables in target location '" + managedFile.targetLocation + "' : " + e.getMessage());
                    expandedTargetLocation = managedFile.targetLocation;
                }
                target = new FilePath(build.getWorkspace(), expandedTargetLocation);
                String immediateFileName = expandedTargetLocation.substring(expandedTargetLocation.lastIndexOf("/") + 1);
                if (immediateFileName.length() == 0 || target.exists() && target.isDirectory()) {
                    target = new FilePath(target, configFile.name.replace(" ", "_"));
                }
            }
            String fileContent = ManagedFileUtil.insertCredentialsInSettings(build, configFile);
            listener.getLogger().println(Messages.console_output(configFile.name, target.toURI()));
            ByteArrayInputStream bs = new ByteArrayInputStream(fileContent.getBytes());
            target.copyFrom((InputStream)bs);
            file2Path.put(managedFile, target);
        }
        return file2Path;
    }

    private static String insertCredentialsInSettings(AbstractBuild<?, ?> build, Config configFile) throws IOException {
        String fileContent = configFile.content;
        if (configFile instanceof HasServerCredentialMappings) {
            HasServerCredentialMappings settings = (HasServerCredentialMappings)((Object)configFile);
            Map<String, StandardUsernameCredentials> resolvedCredentials = CredentialsHelper.resolveCredentials((Item)build.getProject(), settings.getServerCredentialMappings());
            if (!resolvedCredentials.isEmpty()) {
                try {
                    fileContent = CredentialsHelper.fillAuthentication(fileContent, resolvedCredentials);
                }
                catch (Exception exception) {
                    throw new IOException("[ERROR] could not insert credentials into the settings file", exception);
                }
            }
        }
        return fileContent;
    }

    private static ConfigProvider getProviderForConfigId(String id) {
        if (!StringUtils.isBlank((String)id)) {
            for (ConfigProvider provider : ConfigProvider.all()) {
                if (!provider.isResponsibleFor(id)) continue;
                return provider;
            }
        }
        return null;
    }
}

