/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.configfiles.buildwrapper;

import hudson.Extension;
import hudson.ExtensionList;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.tasks.BuildWrapper;
import hudson.tasks.BuildWrapperDescriptor;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.lib.configprovider.ConfigProvider;
import org.jenkinsci.lib.configprovider.model.Config;
import org.jenkinsci.plugins.configfiles.buildwrapper.ManagedFile;
import org.jenkinsci.plugins.configfiles.buildwrapper.ManagedFileUtil;
import org.jenkinsci.plugins.configfiles.buildwrapper.Messages;
import org.jenkinsci.plugins.configfiles.common.CleanTempFilesAction;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigFileBuildWrapper
extends BuildWrapper {
    private List<ManagedFile> managedFiles = new ArrayList<ManagedFile>();

    @DataBoundConstructor
    public ConfigFileBuildWrapper(List<ManagedFile> managedFiles) {
        this.managedFiles = managedFiles;
    }

    public BuildWrapper.Environment setUp(AbstractBuild build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
        PrintStream logger = listener.getLogger();
        if (build.getWorkspace() == null) {
            throw new IllegalStateException("the workspace does not yet exist, can't provision config files - maybe slave is offline?");
        }
        Map<ManagedFile, FilePath> file2Path = ManagedFileUtil.provisionConfigFiles(this.managedFiles, build, listener);
        ManagedFilesEnvironment env = new ManagedFilesEnvironment(file2Path);
        build.addAction((Action)new CleanTempFilesAction(file2Path));
        return env;
    }

    public List<ManagedFile> getManagedFiles() {
        return this.managedFiles;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ManagedFilesEnvironment
    extends BuildWrapper.Environment {
        private final Map<ManagedFile, FilePath> file2Path;

        public ManagedFilesEnvironment(Map<ManagedFile, FilePath> file2Path) {
            super((BuildWrapper)ConfigFileBuildWrapper.this);
            this.file2Path = file2Path == null ? Collections.emptyMap() : file2Path;
        }

        public void buildEnvVars(Map<String, String> env) {
            for (Map.Entry<ManagedFile, FilePath> entry : this.file2Path.entrySet()) {
                ManagedFile mf = entry.getKey();
                FilePath fp = entry.getValue();
                if (StringUtils.isBlank((String)mf.variable)) continue;
                env.put(mf.variable, fp.getRemote());
            }
        }

        List<String> getTempFiles() {
            ArrayList<String> tempFiles = new ArrayList<String>();
            for (Map.Entry<ManagedFile, FilePath> entry : this.file2Path.entrySet()) {
                boolean noTargetGiven = StringUtils.isBlank((String)entry.getKey().targetLocation);
                if (!noTargetGiven) continue;
                tempFiles.add(entry.getValue().getRemote());
            }
            return tempFiles;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension(ordinal=50.0)
    public static final class DescriptorImpl
    extends BuildWrapperDescriptor {
        public String getDisplayName() {
            return Messages.display_name();
        }

        public boolean isApplicable(AbstractProject<?, ?> item) {
            return true;
        }

        public Collection<Config> getConfigFiles() {
            ExtensionList<ConfigProvider> providers = ConfigProvider.all();
            ArrayList<Config> allFiles = new ArrayList<Config>();
            for (ConfigProvider provider : providers) {
                allFiles.addAll(provider.getAllConfigs());
            }
            return allFiles;
        }
    }
}

