/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.configfiles;

import hudson.Extension;
import hudson.model.Hudson;
import hudson.model.ManagementLink;
import hudson.security.Permission;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.lib.configprovider.ConfigProvider;
import org.jenkinsci.lib.configprovider.model.Config;
import org.jenkinsci.lib.configprovider.model.ContentType;
import org.jenkinsci.plugins.configfiles.Messages;
import org.kohsuke.stapler.HttpRedirect;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Extension
public class ConfigFilesManagement
extends ManagementLink {
    public String getDisplayName() {
        return Messages.display_name();
    }

    public String getDescription() {
        return Messages.description();
    }

    public String getIconFileName() {
        return "/plugin/config-file-provider/images/cfg_logo.png";
    }

    public String getUrlName() {
        return "configfiles";
    }

    public ContentType getContentTypeForProvider(String providerId) {
        for (ConfigProvider provider : ConfigProvider.all()) {
            if (!provider.getProviderId().equals(providerId)) continue;
            return provider.getContentType();
        }
        return null;
    }

    public List<ConfigProvider> getProviders() {
        return ConfigProvider.all();
    }

    public Collection<Config> getConfigs() {
        ArrayList<Config> all = new ArrayList<Config>();
        for (ConfigProvider provider : ConfigProvider.all()) {
            all.addAll(provider.getAllConfigs());
        }
        return Collections.unmodifiableCollection(all);
    }

    public HttpResponse doSaveConfig(StaplerRequest req) {
        this.checkPermission(Hudson.ADMINISTER);
        try {
            JSONObject json = req.getSubmittedForm().getJSONObject("config");
            Config config = (Config)req.bindJSON(Config.class, json);
            for (ConfigProvider provider : ConfigProvider.all()) {
                if (!provider.isResponsibleFor(config.id)) continue;
                provider.save(config);
            }
        }
        catch (ServletException e) {
            e.printStackTrace();
        }
        return new HttpRedirect("index");
    }

    public void doShow(StaplerRequest req, StaplerResponse rsp, @QueryParameter(value="id") String confgiId) throws IOException, ServletException {
        ConfigProvider provider = this.getProviderForConfigId(confgiId);
        Config config = provider.getConfigById(confgiId);
        if (config != null) {
            req.setAttribute("contentType", (Object)provider.getContentType());
            req.setAttribute("config", (Object)config);
            req.getView((Object)this, "show.jelly").forward((ServletRequest)req, (ServletResponse)rsp);
        }
    }

    public void doEditConfig(StaplerRequest req, StaplerResponse rsp, @QueryParameter(value="id") String confgiId) throws IOException, ServletException {
        this.checkPermission(Hudson.ADMINISTER);
        ConfigProvider provider = this.getProviderForConfigId(confgiId);
        Config config = provider.getConfigById(confgiId);
        if (config != null) {
            req.setAttribute("contentType", (Object)provider.getContentType());
            req.setAttribute("config", (Object)config);
            req.setAttribute("provider", (Object)provider);
            req.getView((Object)this, "edit.jelly").forward((ServletRequest)req, (ServletResponse)rsp);
        } else {
            req.getView((Object)this, "index").forward((ServletRequest)req, (ServletResponse)rsp);
        }
    }

    public void doAddConfig(StaplerRequest req, StaplerResponse rsp, @QueryParameter(value="providerId") String providerId) throws IOException, ServletException {
        this.checkPermission(Hudson.ADMINISTER);
        for (ConfigProvider provider : ConfigProvider.all()) {
            if (!provider.getProviderId().equals(providerId)) continue;
            req.setAttribute("contentType", (Object)provider.getContentType());
            req.setAttribute("provider", (Object)provider);
            Config config = provider.newConfig();
            req.setAttribute("config", (Object)config);
            break;
        }
        req.getView((Object)this, "edit.jelly").forward((ServletRequest)req, (ServletResponse)rsp);
    }

    public void doSelectProvider(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        this.checkPermission(Hudson.ADMINISTER);
        req.setAttribute("providers", ConfigProvider.all());
        req.getView((Object)this, "selectprovider.jelly").forward((ServletRequest)req, (ServletResponse)rsp);
    }

    private void checkPermission(Permission permission) {
        Hudson.getInstance().checkPermission(permission);
    }

    public HttpResponse doRemoveConfig(StaplerRequest res, StaplerResponse rsp, @QueryParameter(value="id") String configId) throws IOException {
        this.checkPermission(Hudson.ADMINISTER);
        for (ConfigProvider provider : ConfigProvider.all()) {
            if (!provider.isResponsibleFor(configId)) continue;
            provider.remove(configId);
        }
        return new HttpRedirect("index");
    }

    private ConfigProvider getProviderForConfigId(String id) {
        if (!StringUtils.isBlank((String)id)) {
            for (ConfigProvider provider : ConfigProvider.all()) {
                if (!provider.isResponsibleFor(id)) continue;
                return provider;
            }
        }
        return null;
    }
}

