/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.lib.configprovider;

import hudson.BulkChange;
import hudson.XmlFile;
import hudson.model.Saveable;
import hudson.model.listeners.SaveableListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.jenkinsci.lib.configprovider.ConfigProvider;
import org.jenkinsci.lib.configprovider.model.Config;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractConfigProviderImpl
extends ConfigProvider {
    private static final Logger LOGGER = Logger.getLogger(AbstractConfigProviderImpl.class.getName());
    protected Map<String, Config> configs = new HashMap<String, Config>();

    @Override
    public Collection<Config> getAllConfigs() {
        ArrayList<Config> c = new ArrayList<Config>(this.configs.values());
        Collections.sort(c, new NameComparator());
        return Collections.unmodifiableCollection(c);
    }

    @Override
    public Config getConfigById(String configId) {
        return this.configs.get(configId);
    }

    @Override
    public String getProviderId() {
        return this.getId();
    }

    @Override
    public boolean isResponsibleFor(String configId) {
        return configId != null && configId.startsWith(this.getProviderId());
    }

    @Override
    public Config newConfig() {
        String id = this.getProviderId() + "." + System.currentTimeMillis();
        return new Config(id, null, null, null);
    }

    @Override
    public void remove(String configId) {
        this.configs.remove(configId);
        this.save();
    }

    @Override
    public void save(Config config) {
        this.configs.put(config.id, config);
        this.save();
    }

    public synchronized void save() {
        if (BulkChange.contains((Saveable)this)) {
            return;
        }
        try {
            this.getConfigXml().write((Object)this);
            SaveableListener.fireOnChange((Saveable)this, (XmlFile)this.getConfigXml());
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Failed to save " + this.getConfigXml(), e);
        }
    }

    public void load() {
        XmlFile xml = this.getConfigXml();
        if (xml.exists()) {
            try {
                xml.unmarshal((Object)this);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    protected XmlFile getConfigXml() {
        return new XmlFile(Jenkins.XSTREAM, new File(Jenkins.getInstance().getRootDir(), this.getXmlFileName()));
    }

    protected String getXmlFileName() {
        return this.getId() + ".xml";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class NameComparator
    implements Comparator<Config> {
        private NameComparator() {
        }

        @Override
        public int compare(Config o1, Config o2) {
            String a = o1.name != null ? o1.name : "";
            String b = o2.name != null ? o2.name : "";
            return a.compareTo(b);
        }
    }
}

