/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.configfiles.maven.job;

import com.cloudbees.plugins.credentials.common.StandardUsernameCredentials;
import hudson.Extension;
import hudson.FilePath;
import hudson.model.AbstractBuild;
import hudson.model.Action;
import hudson.model.ItemGroup;
import hudson.model.TaskListener;
import hudson.util.ListBoxModel;
import java.util.ArrayList;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.mvn.GlobalSettingsProvider;
import jenkins.mvn.GlobalSettingsProviderDescriptor;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.lib.configprovider.model.Config;
import org.jenkinsci.plugins.configfiles.ConfigFiles;
import org.jenkinsci.plugins.configfiles.buildwrapper.ManagedFileUtil;
import org.jenkinsci.plugins.configfiles.common.CleanTempFilesAction;
import org.jenkinsci.plugins.configfiles.maven.GlobalMavenSettingsConfig;
import org.jenkinsci.plugins.configfiles.maven.job.SimpleEnvironment;
import org.jenkinsci.plugins.configfiles.maven.security.CredentialsHelper;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;

public class MvnGlobalSettingsProvider
extends GlobalSettingsProvider {
    private static final Logger LOGGER = Logger.getLogger(MvnGlobalSettingsProvider.class.getName());
    private String settingsConfigId;

    @Deprecated
    public MvnGlobalSettingsProvider() {
    }

    @DataBoundConstructor
    public MvnGlobalSettingsProvider(String settingsConfigId) {
        this.settingsConfigId = settingsConfigId;
    }

    public String getSettingsConfigId() {
        return this.settingsConfigId;
    }

    public void setSettingsConfigId(String settingsConfigId) {
        this.settingsConfigId = settingsConfigId;
    }

    public FilePath supplySettings(AbstractBuild<?, ?> build, TaskListener listener) {
        if (StringUtils.isNotBlank((String)this.settingsConfigId)) {
            Object c = ConfigFiles.getByIdOrNull(build.getRootBuild(), this.settingsConfigId);
            if (c == null) {
                String msg = "your Apache Maven build is setup to use a global config with id " + this.settingsConfigId + " but can not find the config";
                listener.getLogger().println("ERROR: " + msg);
                throw new IllegalStateException(msg);
            }
            GlobalMavenSettingsConfig config = c instanceof GlobalMavenSettingsConfig ? (GlobalMavenSettingsConfig)c : new GlobalMavenSettingsConfig(((Config)c).id, ((Config)c).name, ((Config)c).comment, ((Config)c).content, GlobalMavenSettingsConfig.isReplaceAllDefault, null);
            listener.getLogger().println("using global settings config with name " + config.name);
            listener.getLogger().println("Replacing all maven server entries not found in credentials list is " + config.getIsReplaceAll());
            if (StringUtils.isNotBlank((String)config.content)) {
                try {
                    FilePath workspace = build.getWorkspace();
                    if (workspace != null) {
                        FilePath workDir = ManagedFileUtil.tempDir(workspace);
                        String fileContent = config.content;
                        Map<String, StandardUsernameCredentials> resolvedCredentials = CredentialsHelper.resolveCredentials(build, config.getServerCredentialMappings());
                        Boolean isReplaceAll = config.getIsReplaceAll();
                        if (resolvedCredentials != null && !resolvedCredentials.isEmpty()) {
                            ArrayList<String> tempFiles = new ArrayList<String>();
                            fileContent = CredentialsHelper.fillAuthentication(fileContent, isReplaceAll, resolvedCredentials, workDir, tempFiles);
                            for (String tempFile : tempFiles) {
                                build.addAction((Action)new CleanTempFilesAction(tempFile));
                            }
                        }
                        FilePath configurationFile = workspace.createTextTempFile("global-settings", ".xml", fileContent, false);
                        LOGGER.log(Level.FINE, "Create {0}", new Object[]{configurationFile});
                        build.getEnvironments().add((Object)new SimpleEnvironment("MVN_GLOBALSETTINGS", configurationFile.getRemote()));
                        build.addAction((Action)new CleanTempFilesAction(configurationFile.getRemote()));
                        return configurationFile;
                    }
                    listener.getLogger().println("ERROR: can't supply maven settings, workspace is null / slave seems not contected...");
                }
                catch (Exception e) {
                    throw new IllegalStateException("the global settings.xml could not be supplied for the current build: " + e.getMessage());
                }
            }
        }
        return null;
    }

    @Extension(ordinal=10.0)
    public static class DescriptorImpl
    extends GlobalSettingsProviderDescriptor {
        public String getDisplayName() {
            return "provided global settings.xml";
        }

        public ListBoxModel doFillSettingsConfigIdItems(@AncestorInPath ItemGroup context) {
            ListBoxModel items = new ListBoxModel();
            items.add("please select", "");
            for (Config config : ConfigFiles.getConfigsInContext(context, GlobalMavenSettingsConfig.GlobalMavenSettingsConfigProvider.class)) {
                items.add(config.name, config.id);
            }
            return items;
        }
    }
}

