/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.configfiles.maven;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import jenkins.model.Jenkins;
import org.jenkinsci.lib.configprovider.ConfigProvider;
import org.jenkinsci.lib.configprovider.model.Config;
import org.jenkinsci.lib.configprovider.model.ContentType;
import org.jenkinsci.plugins.configfiles.Messages;
import org.jenkinsci.plugins.configfiles.maven.AbstractMavenSettingsProvider;
import org.jenkinsci.plugins.configfiles.maven.security.HasServerCredentialMappings;
import org.jenkinsci.plugins.configfiles.maven.security.ServerCredentialMapping;
import org.kohsuke.stapler.DataBoundConstructor;

public class GlobalMavenSettingsConfig
extends Config
implements HasServerCredentialMappings {
    private static final long serialVersionUID = 1L;
    private List<ServerCredentialMapping> serverCredentialMappings;
    public Boolean isReplaceAll = isReplaceAllDefault;
    public static final Boolean isReplaceAllDefault = Boolean.TRUE;

    @DataBoundConstructor
    public GlobalMavenSettingsConfig(String id, String name, String comment, String content, Boolean isReplaceAll, List<ServerCredentialMapping> serverCredentialMappings) {
        super(id, name, comment, content, GlobalMavenSettingsConfigProvider.class.getName());
        this.serverCredentialMappings = serverCredentialMappings == null ? new ArrayList() : serverCredentialMappings;
        this.isReplaceAll = null == isReplaceAll ? isReplaceAllDefault : isReplaceAll;
    }

    public GlobalMavenSettingsConfig(String id, String name, String comment, String content) {
        super(id, name, comment, content, GlobalMavenSettingsConfigProvider.class.getName());
    }

    @Override
    public List<ServerCredentialMapping> getServerCredentialMappings() {
        return this.serverCredentialMappings;
    }

    @Override
    public Boolean getIsReplaceAll() {
        return this.isReplaceAll;
    }

    @Override
    public ConfigProvider getDescriptor() {
        return (ConfigProvider)Jenkins.getActiveInstance().getDescriptorByType(GlobalMavenSettingsConfigProvider.class);
    }

    @Extension(ordinal=200.0)
    public static class GlobalMavenSettingsConfigProvider
    extends AbstractMavenSettingsProvider {
        protected transient String ID_PREFIX;

        public GlobalMavenSettingsConfigProvider() {
            this.load();
        }

        @Override
        public ContentType getContentType() {
            return ContentType.DefinedType.XML;
        }

        public String getDisplayName() {
            return Messages.mvn_global_settings_provider_name();
        }

        @Override
        public Config newConfig() {
            String id = this.getProviderId() + System.currentTimeMillis();
            return new GlobalMavenSettingsConfig(id, "MyGlobalSettings", "global settings", this.loadTemplateContent(), isReplaceAllDefault, Collections.emptyList());
        }

        @Override
        @NonNull
        public Config newConfig(@NonNull String id) {
            return new GlobalMavenSettingsConfig(id, "MyGlobalSettings", "global settings", this.loadTemplateContent(), isReplaceAllDefault, Collections.emptyList());
        }

        @Override
        protected String getXmlFileName() {
            return "maven-global-settings-files.xml";
        }

        static {
            Jenkins.XSTREAM.alias("org.jenkinsci.plugins.configfiles.maven.DefaultGlobalMavenSettingsProvider", GlobalMavenSettingsConfigProvider.class);
        }
    }
}

