/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.configfiles.json;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import jenkins.model.Jenkins;
import org.jenkinsci.lib.configprovider.AbstractConfigProviderImpl;
import org.jenkinsci.lib.configprovider.ConfigProvider;
import org.jenkinsci.lib.configprovider.model.Config;
import org.jenkinsci.lib.configprovider.model.ContentType;
import org.jenkinsci.plugins.configfiles.Messages;
import org.kohsuke.stapler.DataBoundConstructor;

public class JsonConfig
extends Config {
    private static final long serialVersionUID = 1L;

    public JsonConfig(String id, String name, String comment, String content) {
        super(id, name, comment, JsonConfig.fixJsonContent(content));
    }

    @DataBoundConstructor
    public JsonConfig(String id, String name, String comment, String content, String providerId) {
        super(id, name, comment, JsonConfig.fixJsonContent(content), providerId);
    }

    private static String fixJsonContent(String content) {
        String c = content.trim();
        if (c.startsWith("\"") && c.endsWith("\"")) {
            return c.substring(1, c.length() - 1);
        }
        return c;
    }

    @Override
    public ConfigProvider getDescriptor() {
        return (ConfigProvider)Jenkins.getActiveInstance().getDescriptorByType(JsonConfigProvider.class);
    }

    @Extension(ordinal=180.0)
    public static class JsonConfigProvider
    extends AbstractConfigProviderImpl {
        public JsonConfigProvider() {
            this.load();
        }

        @Override
        public ContentType getContentType() {
            return new ContentType(){

                @Override
                public String getCmMode() {
                    return "javascript";
                }

                @Override
                public String getMime() {
                    return "application/json";
                }
            };
        }

        public String getDisplayName() {
            return Messages.json_provider_name();
        }

        @Override
        public Config newConfig() {
            String id = this.getProviderId() + System.currentTimeMillis();
            return new JsonConfig(id, "JsonConfig", "", "{}");
        }

        @Override
        @NonNull
        public Config newConfig(@NonNull String id) {
            return new JsonConfig(id, "JsonConfig", "", "{}", this.getProviderId());
        }

        @Override
        public <T extends Config> T convert(Config config) {
            return (T)new JsonConfig(config.id, config.name, config.comment, config.content, this.getProviderId());
        }
    }
}

