/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.configfiles.folder;

import com.cloudbees.hudson.plugins.folder.AbstractFolder;
import com.cloudbees.hudson.plugins.folder.AbstractFolderProperty;
import com.cloudbees.hudson.plugins.folder.Folder;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.Util;
import hudson.model.Action;
import hudson.model.Hudson;
import hudson.security.Permission;
import hudson.util.FormValidation;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import jenkins.model.TransientActionFactory;
import net.sf.json.JSONObject;
import org.jenkinsci.lib.configprovider.ConfigProvider;
import org.jenkinsci.lib.configprovider.model.Config;
import org.jenkinsci.lib.configprovider.model.ContentType;
import org.jenkinsci.plugins.configfiles.ConfigFileStore;
import org.jenkinsci.plugins.configfiles.ConfigFilesUIContract;
import org.jenkinsci.plugins.configfiles.Messages;
import org.jenkinsci.plugins.configfiles.folder.FolderConfigFileProperty;
import org.kohsuke.stapler.HttpRedirect;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public class FolderConfigFileAction
implements Action,
ConfigFilesUIContract {
    private Folder folder;

    FolderConfigFileAction(Folder folder) {
        this.folder = folder;
    }

    public Folder getFolder() {
        return this.folder;
    }

    public String getIconFileName() {
        return "/plugin/config-file-provider/images/cfg_logo.png";
    }

    public String getDisplayName() {
        return "Config Files";
    }

    public String getUrlName() {
        return "configfiles";
    }

    @Override
    public ContentType getContentTypeForProvider(String providerId) {
        for (ConfigProvider provider : ConfigProvider.all()) {
            if (!provider.getProviderId().equals(providerId)) continue;
            return provider.getContentType();
        }
        return null;
    }

    @Override
    public Map<ConfigProvider, Collection<Config>> getGroupedConfigs() {
        ConfigFileStore store = this.getStore();
        Map<ConfigProvider, Collection<Config>> groupedConfigs = store.getGroupedConfigs();
        return groupedConfigs;
    }

    @Override
    public List<ConfigProvider> getProviders() {
        ExtensionList<ConfigProvider> all = ConfigProvider.all();
        ArrayList<ConfigProvider> folderSupportedProviders = new ArrayList<ConfigProvider>();
        for (ConfigProvider p : all) {
            if (!p.supportsFolder()) continue;
            folderSupportedProviders.add(p);
        }
        return folderSupportedProviders;
    }

    @Override
    public HttpResponse doSaveConfig(StaplerRequest req) throws IOException, ServletException {
        this.checkPermission(Hudson.ADMINISTER);
        try {
            JSONObject json = req.getSubmittedForm().getJSONObject("config");
            Config config = (Config)req.bindJSON(Config.class, json);
            ConfigFileStore store = this.getStore();
            store.remove(config.id);
            store.save(config);
        }
        catch (ServletException e) {
            e.printStackTrace();
        }
        return new HttpRedirect("index");
    }

    ConfigFileStore getStore() {
        FolderConfigFileProperty folderConfigFileProperty = (FolderConfigFileProperty)this.folder.getProperties().get(FolderConfigFileProperty.class);
        if (folderConfigFileProperty == null) {
            folderConfigFileProperty = new FolderConfigFileProperty((AbstractFolder<?>)this.folder);
            try {
                this.folder.addProperty((AbstractFolderProperty)folderConfigFileProperty);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return folderConfigFileProperty;
    }

    @Override
    public void doShow(StaplerRequest req, StaplerResponse rsp, @QueryParameter(value="id") String confgiId) throws IOException, ServletException {
        Config config = this.getStore().getById(confgiId);
        req.setAttribute("contentType", (Object)config.getProvider().getContentType());
        req.setAttribute("config", (Object)config);
        req.getView((Object)this, "show.jelly").forward((ServletRequest)req, (ServletResponse)rsp);
    }

    @Override
    public void doEditConfig(StaplerRequest req, StaplerResponse rsp, @QueryParameter(value="id") String confgiId) throws IOException, ServletException {
        this.checkPermission(Hudson.ADMINISTER);
        Config config = this.getStore().getById(confgiId);
        req.setAttribute("contentType", (Object)config.getProvider().getContentType());
        req.setAttribute("config", (Object)config);
        req.setAttribute("provider", (Object)config.getProvider());
        req.getView((Object)this, "edit.jelly").forward((ServletRequest)req, (ServletResponse)rsp);
    }

    @Override
    public void doAddConfig(StaplerRequest req, StaplerResponse rsp, @QueryParameter(value="providerId") String providerId, @QueryParameter(value="configId") String configId) throws IOException, ServletException {
        this.checkPermission(Hudson.ADMINISTER);
        FormValidation error = null;
        if (providerId == null || providerId.isEmpty()) {
            error = FormValidation.errorWithMarkup((String)Messages._ConfigFilesManagement_selectTypeOfFileToCreate().toString(req.getLocale()));
        }
        if (configId == null || configId.isEmpty()) {
            error = FormValidation.errorWithMarkup((String)Messages._ConfigFilesManagement_configIdCannotBeEmpty().toString(req.getLocale()));
        }
        if (error != null) {
            req.setAttribute("error", (Object)error);
            this.checkPermission(Hudson.ADMINISTER);
            req.setAttribute("providers", this.getProviders());
            req.setAttribute("configId", (Object)configId);
            req.getView((Object)this, "selectprovider.jelly").forward((ServletRequest)req, (ServletResponse)rsp);
            return;
        }
        ConfigProvider provider = ConfigProvider.getByIdOrNull(providerId);
        if (provider == null) {
            throw new IllegalArgumentException("No provider found for id '" + providerId + "'");
        }
        req.setAttribute("contentType", (Object)provider.getContentType());
        req.setAttribute("provider", (Object)provider);
        Config config = Util.isOverridden(ConfigProvider.class, ((Object)((Object)provider)).getClass(), (String)"newConfig", (Class[])new Class[]{String.class}) ? provider.newConfig(configId) : provider.newConfig();
        config.setProviderId(provider.getProviderId());
        req.setAttribute("config", (Object)config);
        req.getView((Object)this, "edit.jelly").forward((ServletRequest)req, (ServletResponse)rsp);
    }

    @Override
    public void doSelectProvider(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        this.checkPermission(Hudson.ADMINISTER);
        req.setAttribute("providers", this.getProviders());
        req.setAttribute("configId", (Object)UUID.randomUUID().toString());
        req.getView((Object)this, "selectprovider.jelly").forward((ServletRequest)req, (ServletResponse)rsp);
    }

    @Override
    public HttpResponse doRemoveConfig(StaplerRequest res, StaplerResponse rsp, @QueryParameter(value="id") String configId) throws IOException {
        this.checkPermission(Hudson.ADMINISTER);
        this.getStore().remove(configId);
        return new HttpRedirect("index");
    }

    @Override
    public FormValidation doCheckConfigId(@QueryParameter(value="configId") String configId) {
        if (configId == null || configId.isEmpty()) {
            return FormValidation.warning((String)Messages.ConfigFilesManagement_configIdCannotBeEmpty());
        }
        Config config = this.getStore().getById(configId);
        if (config == null) {
            return FormValidation.ok();
        }
        return FormValidation.warning((String)Messages.ConfigFilesManagement_configIdAlreadyUsed(config.name, config.id));
    }

    private void checkPermission(Permission permission) {
        Hudson.getInstance().checkPermission(permission);
    }

    @Extension(optional=true)
    public static class ActionFactory
    extends TransientActionFactory<Folder> {
        public Class<Folder> type() {
            return Folder.class;
        }

        public Collection<? extends Action> createFor(Folder target) {
            return Collections.singleton(new FolderConfigFileAction(target));
        }
    }
}

