/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.configfiles.common;

import hudson.Extension;
import hudson.FilePath;
import hudson.model.AbstractBuild;
import hudson.model.Node;
import hudson.model.TaskListener;
import hudson.model.listeners.RunListener;
import hudson.remoting.VirtualChannel;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jenkinsci.plugins.configfiles.common.CleanTempFilesAction;

@Extension
public class CleanTempFilesRunListener
extends RunListener<AbstractBuild<?, ?>> {
    private static final Logger LOGGER = Logger.getLogger(CleanTempFilesRunListener.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onCompleted(AbstractBuild<?, ?> build, TaskListener listener) {
        List actions = build.getActions(CleanTempFilesAction.class);
        for (CleanTempFilesAction action : actions) {
            try {
                for (String remotePath : action.getTempFiles()) {
                    LOGGER.log(Level.FINE, "Delete {0}", new Object[]{remotePath});
                    try {
                        FilePath fp;
                        VirtualChannel channel;
                        Node builtOn = build.getBuiltOn();
                        if (builtOn == null || (channel = builtOn.getChannel()) == null || !(fp = new FilePath(channel, remotePath)).exists()) continue;
                        fp.delete();
                    }
                    catch (Exception e) {
                        listener.getLogger().println("[WARN] failed to delete temp file: " + remotePath + " - " + e.getMessage());
                    }
                }
            }
            finally {
                build.getActions().remove((Object)action);
            }
        }
    }
}

